/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.common.clients.dw.mdb;

import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.domain.dw.mdb.KettleInsertData;
import cn.gtmap.gtc.common.domain.dw.mdb.MetaInstance;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(value="mdb-app", configuration={MultipartSupportConfig.class})
@RequestMapping(value={"/mdb/v1/datastore"})
public interface DataStoreClient {
    @PostMapping(value={"/dbtype"})
    public ResultBean createDbType(@RequestParam(name="typeName") String var1, @RequestParam(name="description") String var2);

    @PutMapping(value={"/dbtype"})
    public ResultBean updateDbType(@RequestParam(name="id") String var1, @RequestParam(name="description") String var2);

    @DeleteMapping(value={"/dbtype/{id}"})
    public ResultBean deleteDbType(@PathVariable(name="id") String var1);

    @ApiOperation(value="\u5217\u51fa\u6570\u636e\u5e93\u7c7b\u578b")
    @GetMapping(value={"/dbtype/list"})
    public ResultBean ListDbType();

    @PostMapping(value={"/instance"})
    public ResultBean registerInstance(@RequestParam(name="dbTypeId") String var1, @RequestParam(name="instanceName") String var2, @RequestParam(name="description") String var3, @RequestParam(name="parameters") String var4);

    @PutMapping(value={"/instance"})
    public ResultBean updateRegisteredInstance(@RequestParam(name="instanceId") String var1, @RequestParam(name="decription") String var2);

    @PutMapping(value={"/updateinstance"})
    public ResultBean updateRegisteredInstance1(@RequestParam(name="instanceId") String var1, @RequestParam(name="parameters") String var2);

    @DeleteMapping(value={"/instance/{id}"})
    public ResultBean unRegisterInstance(@PathVariable(name="id") String var1);

    @GetMapping(value={"/instance/list"})
    public PageBean listRegisteredInstance(@RequestParam(name="pageIndex", defaultValue="1") int var1, @RequestParam(name="pageSize", defaultValue="20") int var2, @RequestParam(name="tags", required=false, defaultValue="") Set<String> var3);

    @GetMapping(value={"/instance/{id}"})
    public ResultBean<MetaInstance> queryInstanceById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/layer/list"})
    public ResultBean listLayerName(@RequestParam(name="instanceId") String var1, @RequestParam(name="skipNoGeom", defaultValue="true") boolean var2);

    @GetMapping(value={"/table/list"})
    public PageBean listRegisteredTable(@RequestParam(name="pageIndex", defaultValue="1") int var1, @RequestParam(name="pageSize", defaultValue="20") int var2, @RequestParam(name="tags") Set<String> var3);

    @PostMapping(value={"/table/list1"})
    public PageBean listRegisteredTable1(@RequestParam(name="text") String var1, @RequestParam(name="filterfield", required=false) String var2, @RequestParam(name="guids") Set<String> var3, @RequestParam(name="pageIndex", defaultValue="1") int var4, @RequestParam(name="pageSize", defaultValue="20") int var5);

    @GetMapping(value={"/table/{tableId}"})
    public ResultBean RegisteredTable(@PathVariable(name="tableId") String var1);

    @PostMapping(value={"/table/createThenRegister"})
    public ResultBean createThenRegisterTable(@RequestParam(name="instanceId") String var1, @RequestParam(name="featureType") String var2, @RequestParam(name="attributes") String var3);

    @PostMapping(value={"/table/layer"})
    public ResultBean registerTable(@RequestParam(name="instanceId") String var1, @RequestParam(name="layerName") String var2, @RequestParam(name="attributes", defaultValue="{}", required=false) String var3);

    @DeleteMapping(value={"/table/{id}"})
    public ResultBean unRegisterTable(@PathVariable(name="id") String var1);

    @PutMapping(value={"/table/{id}"})
    public ResultBean updateRegisterTable(@PathVariable(name="id") String var1, @RequestParam(name="attributes") String var2);

    @PutMapping(value={"/table2/{id}"})
    public ResultBean updateRegisterTable1(@PathVariable(name="id") String var1, @RequestParam(name="attributes") String var2, @RequestParam(name="tags", required=false, defaultValue="") Set<String> var3);

    @PutMapping(value={"/table/column/{id}"})
    public ResultBean updateRegisterTableColumn(@PathVariable(name="id") String var1, @RequestParam(name="attributes") String var2);

    @PutMapping(value={"/table/column2/{id}"})
    public ResultBean updateRegisterTableColumn1(@PathVariable(name="id") String var1, @RequestParam(name="attributes") String var2, @RequestParam(name="tags", required=false, defaultValue="") Set<String> var3);

    @PostMapping(value={"/featuretype/customized"})
    public ResultBean createCustomizedFeatureType(@RequestParam(name="featureType") String var1, @RequestParam(name="instanceId") String var2);

    @PostMapping(value={"/featuretype/shp"})
    public ResultBean createFeatureType(@RequestParam(name="name") String var1, @RequestParam(name="dbId") String var2, @RequestParam(name="file") MultipartFile var3);

    @GetMapping(value={"/features"})
    public PageBean queryFeatures(@RequestParam(name="instanceId", required=false) String var1, @RequestParam(name="tableId") String var2, @RequestParam(name="pageIndex", defaultValue="1", required=false) int var3, @RequestParam(name="pageSize", defaultValue="100", required=false) int var4, @RequestParam(name="returnAll", defaultValue="false") Boolean var5);

    @GetMapping(value={"/features/map"})
    public ResultBean queryFeatures(@RequestParam(name="tableId") String var1, @RequestParam(name="outFields", required=false) String[] var2, @RequestParam(name="where") String var3);

    @PostMapping(value={"/access"})
    public ResultBean getDataAccess(@RequestParam(name="parameters") String var1);

    @ApiOperation(value="\u6839\u636e\u8f93\u5165\u6587\u672c\u67e5\u8be2\u5df2\u6ce8\u518c\u6570\u636e\u8868")
    @GetMapping(value={"/table/{text}"})
    public PageBean getMetatableByText(@PathVariable(name="text") String var1, @RequestParam(name="pageIndex", defaultValue="1") Integer var2, @RequestParam(name="pageSize", defaultValue="20") Integer var3);

    @ApiOperation(value="\u5224\u65ad\u5b9e\u4f53\u6307\u5b9a\u5b57\u6bb5\u503c\u9879\u662f\u5426\u5b58\u5728")
    @GetMapping(value={"/table/isexist"})
    public ResultBean getDataAccess(@RequestParam(name="typeName") String var1, @RequestParam(name="fieldName") String var2, @RequestParam(name="fieldValue") String var3);

    @ApiOperation(value="\u591a\u7c7b\u578b\u8f6cgeojson")
    @PostMapping(value={"/togeojson"}, consumes={"multipart/form-data"})
    public ResultBean getGeojson(@RequestParam(name="sourceType") String var1, @RequestParam(name="layerName") String var2, @RequestPart(name="file", required=false) MultipartFile var3);

    @ApiOperation(value="\u591a\u7c7b\u578b\u8f6cgeojson")
    @PostMapping(value={"/togeojsonNoShp"})
    public ResultBean getGeojsonNoShp(@RequestParam(name="sourceType") String var1, @RequestParam(name="layerName") String var2);

    @ApiOperation(value="\u5206\u6790geojson")
    @PostMapping(value={"/fxgeojson"}, consumes={"multipart/form-data"})
    public ResultBean fxGeojson(@RequestParam(name="exeType") String var1, @RequestParam(name="sourceType") String var2, @RequestParam(name="layerName") String var3, @RequestPart(name="file", required=false) MultipartFile var4, @RequestParam(name="jspara") String var5);

    @ApiOperation(value="\u6267\u884c\u751f\u6001\u73af\u5883\u6307\u6570\u5206\u6790")
    @PostMapping(value={"/fxsthjzs"}, consumes={"multipart/form-data"})
    public ResultBean sthjzsAnalysis(@RequestParam(name="sourceType") String var1, @RequestParam(name="layerName") String var2, @RequestPart(name="file", required=false) MultipartFile var3, @RequestParam(name="jspara") String var4);

    @ApiOperation(value="\u6267\u884c\u751f\u6001\u73af\u5883\u6307\u6570\u5206\u6790")
    @PostMapping(value={"/fxsthjzsnoshp"}, consumes={"multipart/form-data"})
    public ResultBean sthjzsAnalysisNoShp(@RequestParam(name="sourceType") String var1, @RequestParam(name="layerName") String var2, @RequestParam(name="jspara") String var3);

    @ApiOperation(value="\u5206\u6790geojson")
    @PostMapping(value={"/fxgeojsonNoShp"})
    public ResultBean fxGeojsonNoShp(@RequestBody MultiValueMap var1);

    @PostMapping(value={"/importresult"})
    public ResultBean importResult(@RequestParam(name="instanceId") String var1, @RequestParam(name="result") String var2, @RequestParam(name="attributes") String var3);

    @PostMapping(value={"/table/createThenRegisterByuser"})
    public ResultBean createThenRegisterTableByuser(@RequestParam(name="instanceId") String var1, @RequestParam(name="createBy") String var2, @RequestParam(name="tableName") String var3, @RequestParam(name="attributes") String var4);

    @PostMapping(value={"/table/kettle"})
    public ResultBean<Boolean> createTable(@RequestParam(name="instanceId") String var1, @RequestParam(name="featureType") String var2);

    @PostMapping(value={"/table/kettle/insert"})
    public ResultBean<Boolean> kettleInsert(@RequestBody KettleInsertData var1);

    @PostMapping(value={"/table/insert"})
    public ResultBean<Boolean> insert(@RequestParam(name="tableId") String var1, @RequestParam(name="listAttributes") String var2);

    @PutMapping(value={"/table/recover"})
    public ResultBean<Boolean> updateFeaturesByVersion(@RequestParam(name="tableId") String var1, @RequestParam(name="listMapField") String var2);

    @Configuration
    public static class MultipartSupportConfig {
        @Bean
        public Encoder feignFormEncoder() {
            return new SpringFormEncoder();
        }
    }
}

