/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class INetUtil {
    public static final String LOCAL_HOST = "127.0.0.1";

    public static String getHostIp() {
        String hostAddress;
        try {
            InetAddress address = INetUtil.getLocalHostLANAddress();
            hostAddress = address.getHostAddress();
            if (hostAddress == null || "".equals(hostAddress)) {
                hostAddress = address.toString();
            }
        }
        catch (UnknownHostException ignore) {
            hostAddress = LOCAL_HOST;
        }
        return hostAddress;
    }

    public static String getHostName() {
        String hostname;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostname = address.getHostName();
            if (hostname == null || "".equals(hostname)) {
                hostname = address.toString();
            }
        }
        catch (UnknownHostException ignore) {
            hostname = LOCAL_HOST;
        }
        return hostname;
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }
}

