/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import javax.servlet.http.HttpServletRequest;

public class ClientInfoUtil {
    public static String getIpAddr(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null) {
            remoteAddr = request.getHeader("x-forwarded-for");
            if (remoteAddr != null && remoteAddr.length() > 15) {
                String[] ips = remoteAddr.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if ("unknown".equalsIgnoreCase(strIp)) continue;
                    remoteAddr = strIp;
                    break;
                }
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("Proxy-Client-IP");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("WL-Proxy-Client-IP");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("HTTP_CLIENT_IP");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("X-Real-IP");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getRemoteAddr();
            }
        }
        return remoteAddr;
    }

    public static String getMACAddress(String ip) {
        String str = "";
        String macAddress = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(new InputStreamReader(p.getInputStream(), "GBK"));
            for (int i = 1; i < 100; ++i) {
                str = input.readLine();
                if ((str = new String(str.getBytes(), "utf-8")) == null || str.indexOf("MAC") <= 1) continue;
                macAddress = str.substring(str.indexOf("=") + 2, str.length());
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return macAddress;
    }

    public static String getComputerName(String ip) {
        String computerName = "";
        String str = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(new InputStreamReader(p.getInputStream(), "GBK"));
            for (int i = 1; i < 100; ++i) {
                str = input.readLine();
                if ((str = new String(str.getBytes(), "utf-8")) == null || (str = str.trim().replaceAll("\\s{1,}", "")).indexOf("<") <= 1) continue;
                computerName = str.substring(0, str.indexOf("<"));
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return computerName;
    }
}

