/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.filter;

import cn.gtmap.estateplat.filter.XssHttpServletRequestWrapper;
import cn.gtmap.estateplat.utils.ClientInfoUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class XssFilter
implements Filter {
    private Map<String, String> whitePageList = new HashMap<String, String>();
    private Map<String, String> whiteIpList = new HashMap<String, String>();
    private String invalidPage = "/common/404.ftl";

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        response.addHeader("x-frame-options", "SAMEORIGIN");
        String currentURL = request.getRequestURI();
        String ip = ClientInfoUtil.getIpAddr(request);
        if (MapUtils.isNotEmpty(this.whiteIpList)) {
            String targetURL;
            if (MapUtils.isNotEmpty(this.whitePageList) && this.whitePageList.containsKey(targetURL = currentURL.substring(currentURL.lastIndexOf("/") + 1, currentURL.length()))) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (this.whiteIpList.containsKey(ip)) {
                chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper(request), (ServletResponse)response);
            } else {
                response.sendRedirect(request.getContextPath() + this.invalidPage);
            }
        } else {
            chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper(request), (ServletResponse)response);
        }
    }

    public void init(FilterConfig config) {
        Object[] arrIp;
        String whiteIp;
        Object[] arrPage;
        String whitePage = config.getInitParameter("WhitePageList");
        if (StringUtils.isNotBlank((CharSequence)whitePage) && ArrayUtils.isNotEmpty((Object[])(arrPage = whitePage.split(";")))) {
            for (int i = 0; i < arrPage.length; ++i) {
                Object key = arrPage[i];
                this.whitePageList.put((String)key, null);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(whiteIp = config.getInitParameter("WhiteIpList"))) && ArrayUtils.isNotEmpty((Object[])(arrIp = whiteIp.split(";")))) {
            for (int i = 0; i < arrIp.length; ++i) {
                Object key = arrIp[i];
                this.whiteIpList.put((String)key, null);
            }
        }
    }
}

