/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String[] verifyReferer = null;
    private String invalidPage = "/common/404.ftl";

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String referer = request.getHeader("Referer");
        boolean b = false;
        for (String vReferer : this.verifyReferer) {
            if (referer != null && !referer.trim().startsWith(vReferer)) continue;
            b = true;
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            break;
        }
        if (!b) {
            response.sendRedirect(request.getContextPath() + this.invalidPage);
            this.logger.error("\u7591\u4f3cCSRF\u653b\u51fb\uff0creferer:" + referer);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String referer = filterConfig.getInitParameter("referer");
        this.verifyReferer = referer.split(",");
    }
}

