package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.transition.QzDYiq;

import java.util.List;

/**
 * 地役权信息接口
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 15-11-19
 */
public interface QzDYiqService {

    /**
     * 根据权利编号获取地役权信息
     *
     * @param qlbh
     * @param table
     * @return
     */
    public QzDYiq getQzDYiqByQlbh(String qlbh, String table);

    /**
     * 根据不动产单元编号获取地役权信息
     *
     * @param bdcdybh
     * @param table
     * @return
     */
    public List<QzDYiq> getQzDYiqListByBdcdybh(String bdcdybh, String table);

    /**
     * 根据业务信息业务号获取地役权信息
     *
     * @param ywh
     * @param table
     * @return
     */
    public List<QzDYiq> getQzDYiqListByYwh(String ywh, String table);
}
