/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.Charsets;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class CuccSmsServiceImpl
implements SmsService {
    private static final String SMS_RESULT_DESCRIPTION = "\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01";
    private HttpClient httpClient;
    private String spCode;
    private String username;
    private String password;
    private String smsUrl;
    private String scheduleTime;

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getSpCode() {
        return this.spCode;
    }

    public void setSpCode(String spCode) {
        this.spCode = spCode;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSmsUrl() {
        return this.smsUrl;
    }

    public void setSmsUrl(String smsUrl) {
        this.smsUrl = smsUrl;
    }

    public String getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(String scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    @Override
    public Boolean sendSms(String phoneNum, String content) throws AppException {
        HttpPost httpPost = new HttpPost(this.smsUrl);
        ArrayList params = Lists.newArrayList();
        params.add(new BasicNameValuePair("SpCode", this.spCode));
        params.add(new BasicNameValuePair("LoginName", this.username));
        params.add(new BasicNameValuePair("Password", this.password));
        params.add(new BasicNameValuePair("MessageContent", content));
        params.add(new BasicNameValuePair("UserNumber", phoneNum));
        params.add(new BasicNameValuePair("SerialNumber", CalendarUtil.getTimeMs()));
        params.add(new BasicNameValuePair("ScheduleTime", StringUtils.isNotBlank((CharSequence)this.scheduleTime) ? this.scheduleTime : ""));
        params.add(new BasicNameValuePair("ExtendAccessNum", ""));
        params.add(new BasicNameValuePair("f", "1"));
        try {
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity((Iterable)params, Charsets.CHARSET_GBK);
            httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            String info = EntityUtils.toString((HttpEntity)entity);
            Boolean smsResult = false;
            String smsDescription = SMS_RESULT_DESCRIPTION;
            if (StringUtils.isNotBlank((CharSequence)info)) {
                List resultList = URLEncodedUtils.parse((String)info, (Charset)Charsets.CHARSET_GBK);
                for (NameValuePair result : resultList) {
                    if ("result".equals(result.getName()) && "0".equals(result.getValue())) {
                        smsResult = true;
                        break;
                    }
                    if (!"description".equals(result.getName())) continue;
                    smsDescription = result.getValue();
                }
            }
            if (!smsResult.booleanValue()) {
                throw new AppException(smsDescription);
            }
        }
        catch (IOException e) {
            new AppException(e);
        }
        return null;
    }
}

