package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.transition.QzJsydsyq;

import java.util.List;

/**
 * 建设用地使用权、宅基地使用权信息接口
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 15-11-19
 */
public interface QzJsydsyqService {

    /**
     * 根据权利编号和表名（视图名）获取建设用地使用权、宅基地使用权信息
     *
     * @param qlbh
     * @param table
     * @return
     */
    public QzJsydsyq getQzJsydsyqByQlbh(String qlbh, String table);

    /**
     * 根据不动产单元编号和表名（视图名）获取建设用地使用权、宅基地使用权信息
     *
     * @param bdcdybh
     * @param table
     * @return
     */
    public List<QzJsydsyq> getQzJsydsyqListByBdcdybh(String bdcdybh, String table);

    /**
     * 根据业务信息业务号和表名（视图名）获取建设用地使用权、宅基地使用权信息
     *
     * @param ywh
     * @param table
     * @return
     */
    public List<QzJsydsyq> getQzJsydsyqListByYwh(String ywh, String table);
}
