package cn.gtmap.estateplat.service.acceptance;
/*
 * @author <a href="mailto:Will@gtmap.cn">Will</a>
 * @version 1.0, 2017-09-01
 * @description 一窗受理项目生命周期管理服务（创建，初始化，删除）
 */

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.Xmxx;

public interface YcslProjectLifeManageService {

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 创建一窗受理项目
     * @param bdcXm 项目信息，包括项目信息YCSL_XM,收件信息YCSL_SJXX,收件材料YCSL_SJCL,
     */

    void createProjectByBdcXm(BdcXm bdcXm);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 创建一窗受理项目
     * @param xmxx 项目信息
     */
    void createProject(Xmxx xmxx);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 初始化一窗受理项目
     * @param xmxx 项目信息
     */
    void initializeProject(Xmxx xmxx);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 删除一窗受理项目
     * @param proid 项目ID
     */
    void deleteProject(String proid);

    /**
     *@Author:<a href="mailto:gaolining@gtmap.cn">gaolining</a>
     *@param:proid
     *@Description:改变拆迁信息的状态
     *@Date 14:18 2018/4/11
     */
    void changeCczt(String proid);
}
