/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import com.gtis.config.AppConfig;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.StringUtils;

public class RSATokenUtil {
    private static int MAXENCRYPTSIZE = 117;

    public static String getRSAToken() {
        String userId = AppConfig.getProperty((String)"user.id");
        String token = "";
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String nowStr = sm.format(now);
            String strMsg = userId + "|" + nowStr;
            try {
                PublicKey publicKey = RSATokenUtil.getPublicKey();
                token = RSATokenUtil.encrypt(strMsg.getBytes(Charset.forName("utf-8")), publicKey);
                token = URLEncoder.encode(token, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return token;
    }

    public static PublicKey getPublicKey() {
        try {
            String modulus = AppConfig.getProperty((String)"user.modulus");
            String exponent = AppConfig.getProperty((String)"user.exponent");
            byte[] m = RSATokenUtil.decodeBase64(modulus);
            byte[] e = RSATokenUtil.decodeBase64(exponent);
            BigInteger b1 = new BigInteger(1, m);
            BigInteger b2 = new BigInteger(1, e);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decodeBase64(String input) throws Exception {
        Class<?> clazz = Class.forName("com.sun.org.apache.xerces.internal.impl.dv.util.Base64");
        Method mainMethod = clazz.getMethod("decode", String.class);
        mainMethod.setAccessible(true);
        Object retObj = mainMethod.invoke(null, input);
        return (byte[])retObj;
    }

    public static String encrypt(byte[] source, PublicKey publicKey) throws Exception {
        String encryptData = "";
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            int length = source.length;
            int offset = 0;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            int i = 0;
            while (length - offset > 0) {
                byte[] cache = length - offset > MAXENCRYPTSIZE ? cipher.doFinal(source, offset, MAXENCRYPTSIZE) : cipher.doFinal(source, offset, length - offset);
                outStream.write(cache, 0, cache.length);
                offset = ++i * MAXENCRYPTSIZE;
            }
            return RSATokenUtil.encodeBase64(outStream.toByteArray());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return encryptData;
    }

    public static String encodeBase64(byte[] input) throws Exception {
        Class<?> clazz = Class.forName("com.sun.org.apache.xerces.internal.impl.dv.util.Base64");
        Method mainMethod = clazz.getMethod("encode", byte[].class);
        mainMethod.setAccessible(true);
        Object retObj = mainMethod.invoke(null, new Object[]{input});
        return (String)retObj;
    }
}

