package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.persistence.Id;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 登记收件信息
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "DJF_DJ_SJ")
public class DjfDjSj implements Serializable, AccessData {
    final static String ysdm = "6004030000";//要素代码
    @Id
    private String sjid;//id
    private String ywh;//业务号
    private Date sjsj;//收件时间
    private String sjlx;//收件类型
    private String sjmc;//收件名称
    private String sjsl;//收件数量
    private String sfsjsy;//是否收缴收验
    private String sfewsj;//是否额外收件
    private String sfbcsj;//是否补充收件
    private Integer ys;//页数
    private String bz;//备注
    private String qxdm;//区县代码

    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @description 文件中心id
     */
    private Integer wjzxid;

    @XmlTransient
    public Integer getWjzxid() {
        return wjzxid;
    }

    public void setWjzxid(Integer wjzxid) {
        this.wjzxid = wjzxid;
    }

    @XmlTransient
    public String getSjid() {
        return sjid;
    }

    public void setSjid(String sjid) {
        this.sjid = sjid;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "SJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getSjsj() {
        return sjsj;
    }

    public void setSjsj(Date sjsj) {
        this.sjsj = sjsj;
    }

    @XmlAttribute(name = "SJLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getSjlx() {
        return sjlx;
    }

    public void setSjlx(String sjlx) {
        this.sjlx = sjlx;
    }

    @XmlAttribute(name = "SJMC")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getSjmc() {
        return sjmc;
    }

    public void setSjmc(String sjmc) {
        this.sjmc = sjmc;
    }

    @XmlAttribute(name = "SJSL")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getSjsl() {
        return sjsl;
    }

    public void setSjsl(String sjsl) {
        this.sjsl = sjsl;
    }

    @XmlAttribute(name = "SFSJSY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getSfsjsy() {
        return sfsjsy;
    }

    public void setSfsjsy(String sfsjsy) {
        this.sfsjsy = sfsjsy;
    }

    @XmlAttribute(name = "SFEWSJ")
    public String getSfewsj() {
        return sfewsj;
    }

    public void setSfewsj(String sfewsj) {
        this.sfewsj = sfewsj;
    }

    @XmlAttribute(name = "SFBCSJ")
    public String getSfbcsj() {
        return sfbcsj;
    }

    public void setSfbcsj(String sfbcsj) {
        this.sfbcsj = sfbcsj;
    }

    @XmlAttribute(name = "YS")
    public Integer getYs() {
        return ys;
    }

    public void setYs(Integer ys) {
        this.ys = ys;
    }

    @XmlAttribute(name = "BZ")
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }
}
