package cn.gtmap.estateplat.core.support.mybatis.mapper;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;

import java.lang.reflect.InvocationTargetException;
import java.sql.Blob;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/6/16
 * @description 类转换器
 */
public class BeanUtilsEx extends BeanUtils {
    static {
        byte byteArray[] = new byte[0];
        ConvertUtils.register(new BlobConvert(), byteArray.getClass());
        ConvertUtils.register(new ClobConvert(), java.lang.String.class);
        ConvertUtils.register(new DateConvert(), java.util.Date.class);
        ConvertUtils.register(new DateConvert(), java.sql.Date.class);
        ConvertUtils.register(new IntegerConvert(), Integer.class);
        ConvertUtils.register(new DoubleConvert(), Double.class);
    }

    public static void copyProperties(Object dest, Object orig) {
        try {
            BeanUtils.copyProperties(dest, orig);
        } catch (IllegalAccessException ex) {
            ex.printStackTrace();
        } catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }
}
