package cn.gtmap.estateplat.service.commodity.house;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018-7-5
 * @description 合同显示接口
 */
public interface HtxsService {
    /**
     * @param url     页面地址
     * @param htid    合同ID
     * @param kfsmbid 开发商模板ID
     * @return FTL路径
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 获取合同显示路径
     */
    String getHtUrl(String url, String htid, String kfsmbid);

    /**
     * @param pageUrl  系统路径
     * @param htid     合同ID
     * @param mbid     模板ID
     * @param disabled 是否编辑
     * @return 页面需要参数
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化合同总页面（总页面）
     */
    Map initHt(String pageUrl, String htid, String mbid, String disabled);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化合同首页（第一章 首页）
     */
    Map initFcjyXjspfMmhtZt(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化商品房基本情况(第二章)
     */
    Map initFcjyXjspfMmhtJbqk(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化商品房价款(第三章)
     */
    Map initFcjyXjspfMmhtJk(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化商品房交付条件与交付手续(第四章)
     */
    Map initFcjyXjspfMmhtJftjsx(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化面积差异处理方式(第五章)
     */
    Map initFcjyXjspfMmhtMjcycl(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化商品房规划设计变更(第六章)
     */
    Map initFcjyXjspfMmhtGhsjbg(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化商品房质量及保修责任(第七章)
     */
    Map initFcjyXjspfMmhtZlbxzr(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化商品房合同备案预房屋登记(第八章)
     */
    Map initFcjyXjspfMmhtHtbafwdj(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化商品房前期物业管理(第九章)
     */
    Map initFcjyXjspfMmhtQqwygl(String htid, String mbid);

    /**
     * @param htid 合同ID
     * @param mbid 模板ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化商品房其他事项(第十章)
     */
    Map initFcjyXjspfMmhtQtsx(HttpServletRequest request, String htid, String mbid);
}
