package cn.gtmap.estateplat.core.ex;


import cn.gtmap.estateplat.utils.Codecs;
import cn.gtmap.estateplat.utils.ExUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-10-11
 */
public class AppException extends RuntimeException implements ErrorCode {
    private static final long serialVersionUID = 5052516665736233092L;
    private String id = Codecs.uuid(8);
    private int code = SERVER_EX;
    private String message;
    private Object args[];

    public AppException() {
        super();
    }

    public AppException(String message) {
        super();
        this.message = message;
    }

    public AppException(Throwable cause) {
        super(cause);
        code = ExUtils.parseCode(cause);
    }

    public AppException(String message, Throwable cause) {
        this(cause);
        this.message = message;
    }

    public AppException(int code, Object... args) {
        super();
        this.code = code;
        this.args = args;
    }

    public AppException(String message, int code, Object... args) {
        this(code, args);
        this.message = message;
    }

    public AppException(Throwable cause, int code, Object... args) {
        super(cause);
        this.code = code;
        this.args = args;
    }

    public AppException(String message, Throwable cause, int code, Object... args) {
        super(cause);
        this.message = message;
        this.code = code;
        this.args = args;
    }

    public String getId() {
        return id;
    }

    public int getCode() {
        return code;
    }

    public Object[] getArgs() {
        return args;
    }

    public String getStack() {
        return ExUtils.buildStackTrace(this);
    }

    public String getMessage() {
        return ExUtils.buildMessage(code, args, message, getCause());
    }

    public String getSimpleMessage() {
        return ExUtils.buildMessage(code, args, message, null);
    }

    public String getSourceMessage(){
        return message;
    }

    @Override
    public String toString() {
        return getMessage();
    }
}
