package cn.gtmap.estateplat.utils;


import cn.gtmap.estateplat.model.server.core.PublicEntity;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 公用方法
 * Created with IntelliJ IDEA.
 * User: zx
 * Date: 14-7-3
 * Time: 下午3:09
 * To change this template use File | Settings | File Templates.
 */
public class CommonUtil<T> {
    /**
     * 获取值，排除空值
     *
     * @param object
     * @return
     */
    public static String formatEmptyValue(Object object) {
        if (object != null)
            return object.toString();
        return "";
    }


    /**
    *@author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
    *@return 返回格式化时间（yyyyMMddHHmmssSSS）字符串
    *@description 2016-07-14 同步获取当前时间 防止重复 可用于各类系统的项目编号
    */
    public static synchronized String getCurrentTimeMillisId(){
        try {
            /**
             * zdd 2016-07-14 必须得等待一毫秒 才能确保不重复
             */
            Thread.sleep(1);
        } catch (Exception e) {
            e.printStackTrace();
        }
        String id = "";
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        id = simpleDateFormat.format(date);
        return id;
    }

    /**
     * 格式化数据double
     *
     * @param object
     * @return
     */
    public static Double formatObjectToDouble(Object object) {
        Double value = 0.0;
        if (object != null) {
            try {
                value = Double.parseDouble(object.toString());
            } catch (Exception e) {
            }
        }
        return value;
    }

    /**
     * 格式化数据整型
     *
     * @param object
     * @return
     */
    public static Integer formatObjectToInteger(Object object) {
        Integer value = 0;
        if (object != null) {
            try {
                value = Integer.parseInt(object.toString());
            } catch (Exception e) {
            }
        }
        return value;
    }

    /**
     * 获取客户端真实ip
     *
     * @param request
     * @return
     */
    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String formatNumber(Double value) {
        if (value == null || value.equals("")) {
            value = 0.0;
        }
        DecimalFormat df = new DecimalFormat("##############0.0");
        String value1 = df.format(value);
        return value1;
    }

    /**
     * 获取子类参数
     *
     * @param publicVoList
     * @param parentId
     * @return
     */
    public static List<PublicEntity> getChildPublicVo(List<PublicEntity> publicVoList, String parentId) {
        List<PublicEntity> publicVoList1 = new ArrayList<PublicEntity>();
        if (publicVoList == null || publicVoList.size() == 0)
            return publicVoList1;
        if (StringUtils.isBlank(parentId))
            return publicVoList;
        for (PublicEntity publicVo : publicVoList) {
            if (publicVo != null && StringUtils.equals(publicVo.getParentId(), parentId)) {
                publicVoList1.add(publicVo);
            }
        }
        return publicVoList1;
    }

    /**
     * 获取父类参数
     *
     * @param publicVoList
     * @return
     */
    public static List<PublicEntity> getParentPublicVo(List<PublicEntity> publicVoList) {
        List<PublicEntity> publicVoList1 = new ArrayList<PublicEntity>();
        if (publicVoList == null || publicVoList.size() == 0)
            return publicVoList1;

        for (PublicEntity publicVo : publicVoList) {
            if (publicVo != null && StringUtils.isBlank(publicVo.getParentId())) {
                publicVoList1.add(publicVo);
            }
        }
        return publicVoList1;
    }

    /**
     * 格式化两位小数
     *
     * @param value
     * @return
     */
    public static Double formatTwoNumber(Double value) {
        DecimalFormat df = new DecimalFormat("##############0.00");
        Double value1 = Double.parseDouble(df.format(value));
        return value1;
    }

    /**
     * 格式化两位小数
     *
     * @param value ["梁凤攀","董洋洋","陈慧玲"]
     * @return
     */
    public static String[] formatStrToList(String value) {
        String[] retValue = null;
        if (StringUtils.isNotBlank(value)) {
            value = value.replaceAll("\\[", "");
            value = value.replaceAll("\\]", "");
            value = value.replaceAll("\\\"", "");
            retValue = value.split(",");
        }
        return retValue;
    }

    /**
     * 将阿拉伯数字转换程中文数字，（只支持两位数）
     *
     * @param value
     * @return
     */
    public static String paseChinaNum(int value) {
        String chinaNum = "";
        char[] valueStr = (value + "").toCharArray();

        char[] SCDigits = {'零', '一', '二', '三', '四', '五', '六', '七', '八', '九'};
        if (valueStr != null && valueStr.length == 2) {
            if (valueStr[0] == 1)
                chinaNum = "十" + SCDigits[Integer.parseInt(valueStr[1] + "")];
            else
                chinaNum = SCDigits[Integer.parseInt(valueStr[0] + "")] + "十" + SCDigits[Integer.parseInt(valueStr[1] + "")];
        } else if (valueStr.length == 1) {
            chinaNum = SCDigits[Integer.parseInt(valueStr[0] + "")] + "";
        }
        return chinaNum;
    }

    public static String getArchiveId(String xml) {
        //创建一个新的字符串
        StringReader read = new StringReader(xml);
        //创建新的输入源SAX 解析器将使用 InputSource 对象来确定如何读取 XML 输入
        InputSource source = new InputSource(read);
        //创建一个新的SAXBuilder
        SAXBuilder sb = new SAXBuilder();
        String archiveProjectId = null;
        try {
            //通过输入源构造一个Document
            org.jdom.Document doc = sb.build(source);
            org.jdom.Element root = doc.getRootElement();
            org.jdom.Element result = root.getChild("archive");
            if (result.getAttributeValue("result") != null && result.getAttributeValue("result").equals("succeed")) {
                org.jdom.Element archive = root.getChild("archive");
                List field = archive.getChildren("field");
                org.jdom.Element fieldId = (org.jdom.Element) field.get(field.size() - 3);
                archiveProjectId = fieldId.getText();
            }
        } catch (JDOMException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return archiveProjectId;
    }

    public static String getArchiveMsg(String xml) {
        String msg = null;
        try {
            if (xml != null && !xml.equals("")) {
                StringReader read = new StringReader(xml);
                //创建新的输入源SAX 解析器将使用 InputSource 对象来确定如何读取 XML 输入
                InputSource source = new InputSource(read);
                //创建一个新的SAXBuilder
                SAXBuilder sb = new SAXBuilder();
                org.jdom.Document doc = sb.build(source);
                org.jdom.Element root = doc.getRootElement();
                org.jdom.Element result = root.getChild("archive");
                if (result.getAttributeValue("msg") != null) {
                    msg = result.getAttributeValue("msg");
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return msg;
    }

    public static String getZszt(String zszt) {
        String zt = "";
        if (StringUtils.equals(zszt, "2"))
            zt = "已转移";
        else if (StringUtils.equals(zszt, "3"))
            zt = "已变更";
        else if (StringUtils.equals(zszt, "4"))
            zt = "已查封";
        else
            zt = "正常";
        return zt;
    }

    /**
     * 读取请求内容并解码
     *
     * @param request
     * @return
     */
    public static String readRequestJsonData(HttpServletRequest request) throws IOException {
        // 读取请求内容
        BufferedReader br = new BufferedReader(new InputStreamReader(request.getInputStream(), "UTF-8"));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        // 将资料解码
        String reqBody = sb.toString();
        reqBody = URLDecoder.decode(reqBody, "UTF-8");
        reqBody = reqBody.replace("'", "\"");
        //无论是大小写，统统转换成小写，为了和vo中一致
        reqBody = reqBody.toLowerCase();
        return reqBody;
    }

    /**
     * jsontoMap
     *
     * @param jsonData
     * @return
     */
    public static Map jsonToMapData(String jsonData, String tblkey) {
        Map<String, Object> mapJson = JSON.parseObject(jsonData);
        Map<String, Object> tempMap = (Map<String, Object>) mapJson.get(tblkey);
        return tempMap;
    }

    /**
     * map转换成vo
     *
     * @param map
     * @param pmsVo
     */
    public static void mapBind(Map map, Object pmsVo) {

        //获得传入vo的Class方法
        Class newClass = pmsVo.getClass();
        //得到vo中所有的成员变量
        Field[] fs = newClass.getDeclaredFields();
        //方法变量
        String methodName = null;
        //map的value值
        Object mapValue = null;
        //参数类型
        String parameterType = null;
        //查找方法时需要传入的参数
        Class[] parameterTypes = new Class[1];
        //执行invoke方法时需要传入的参数
        Object[] args = new Object[1];
        //取得Map的迭代器
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            //取出map的key值
            String key = (String) it.next();
            if (key != null) {
                for (int i = 0; i < fs.length; i++) {
                    if (key.equals(fs[i].getName())) {
                        //拼set方法名
                        methodName = "set" + key.replaceFirst(key.substring(0, 1), key.substring(0, 1).toUpperCase());
                        try {
                            //得到vo中成员变量的类型
                            parameterTypes[0] = fs[i].getType();
                            parameterType = parameterTypes[0].toString();
                            //找到vo中的方法
                            Method method = newClass.getDeclaredMethod(methodName, parameterTypes);
                            mapValue = map.get(key);
                            //下面代码都是参数类型是什么，如果有需求可以自行增加
                            //当set方法中的参数为int或者Integer
                            if (parameterTypes[0] == Integer.class || parameterTypes[0] == int.class) {
                                if (mapValue instanceof Integer) {
                                    args[0] = mapValue;
                                } else {
                                    args[0] = Integer.parseInt((String) mapValue);
                                }
                                //当set方法中的参数为Date
                            } else if (parameterTypes[0] == Date.class) {
                                if (mapValue instanceof Date) {
                                    args[0] = mapValue;
                                } else {
                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                    args[0] = sdf.parse((String) mapValue);
                                }
                                //当set方法中的参数为Float
                            } else if (parameterTypes[0] == double.class || parameterTypes[0] == Double.class) {
                                if (mapValue instanceof Double) {
                                    args[0] = mapValue;
                                } else {
                                    args[0] = Double.parseDouble((String) mapValue);
                                }
                                //当set方法中的参数为其他
                            } else if (parameterTypes[0] == String.class) {

                                if (mapValue instanceof String[]) {

                                    String[] tempArray = (String[]) mapValue;
                                    String result = "";
                                    for (int m = 0; m < tempArray.length; m++) {
                                        result = result + tempArray[m] + ",";
                                    }
                                    result = result.substring(0, result.length() - 1);
                                    args[0] = result;

                                } else {
                                    args[0] = (String) mapValue;
                                }
                            } else {
                                args[0] = mapValue;
                            }
                            //执行set方法存储数据
                            method.invoke(pmsVo, args);

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    /**
     * 获取不动产类型
     *
     * @param bdclxDm
     * @return
     */
    public static String getBdclx(String bdclxDm) {
        String bdclx = "";
        if (StringUtils.isNotBlank(bdclxDm)) {
            if (bdclxDm.indexOf("TD") > -1) {
                if (bdclxDm.indexOf("FW") > -1) {
                    bdclx = "土地、房屋等建筑物";
                } else if (bdclxDm.indexOf("GZW") > -1)
                    bdclx = "土地、构筑物";
                else if (bdclxDm.indexOf("SL") > -1)
                    bdclx = "土地、森林、林木";
                else if (bdclxDm.indexOf("QT") > -1)
                    bdclx = "土地、其他";
                else
                    bdclx = "土地";
            } else if (bdclxDm.indexOf("HY") > -1) {

                if (bdclxDm.indexOf("FW") > -1) {
                    bdclx = "海域、房屋等建筑物";
                } else if (bdclxDm.indexOf("GZW") > -1)
                    bdclx = "海域、构筑物";
                else if (bdclxDm.indexOf("WJM") > -1)
                    bdclx = "海域、无居民海岛";
                else if (bdclxDm.indexOf("SL") > -1)
                    bdclx = "海域、森林、林木";
                else if (bdclxDm.indexOf("QT") > -1)
                    bdclx = "海域、其他";
                else
                    bdclx = "海域";
            }

        }
        return bdclx;
    }

    public static byte[] changeImgSize(byte[] data, int nw, int nh) {
        byte[] newdata = null;
        BufferedImage bis = null;
        ByteArrayOutputStream baos = null;
        try {
            InputStream is = new ByteArrayInputStream(data);
            bis = ImageIO.read(is);
            int w = bis.getWidth();
            int h = bis.getHeight();
            double sx = (double) nw / w;
            double sy = (double) nh / h;
            AffineTransform transform = new AffineTransform();
            transform.setToScale(sx, sy);
            AffineTransformOp ato = new AffineTransformOp(transform, null);
            // 原始颜色
            BufferedImage bid = new BufferedImage(nw, nh,
                    BufferedImage.TYPE_3BYTE_BGR);
            ato.filter(bis, bid);
            // 转换成byte字节
            baos = new ByteArrayOutputStream();
            ImageIO.write(bid, "jpeg", baos);
            newdata = baos.toByteArray();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (null != bis) {
                bis = null;
            }
            try {
                baos.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return newdata;
    }

    /**
     * http GET请求
     *
     * @param url
     * @return
     */
    public static String httpConnect(String url) {
        String json = "";
        HttpURLConnection huc = null;
        try {
            huc = (HttpURLConnection) new URL(url).openConnection();
            huc.setReadTimeout(3000);
            huc.setConnectTimeout(3000);
            huc.setRequestMethod("GET");
            InputStream is = huc.getInputStream();
            if (is != null)
                json = IOUtils.toString(is);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (huc != null)
                huc.disconnect();
        }
        return json;
    }

    /**
     * 两个大数据相加
     *
     * @param aa
     * @param bb
     * @return
     */
    public static String addBigDecimal(Object aa, Object bb) {
        BigDecimal rs = new BigDecimal(0);
        if (aa != null && !"".equals(aa)) {
            rs = rs.add(new BigDecimal(aa.toString()));
        }
        if (bb != null && !"".equals(bb)) {
            rs = rs.add(new BigDecimal(bb.toString()));
        }
        if (rs.toString().equals("0")) {
            return "0";
        } else
            return rs.toString();
    }

    /**
     * 比较字符是否在字符串中
     *
     * @param a
     * @param b
     * @return
     */
    public static boolean indexOfStrs(String[] a, String b) {
        boolean msg = false;
        if (a != null) {
            for (String c : a) {
                if (StringUtils.equals(c, b)) {
                    msg = true;
                    break;
                }
            }
        }
        return msg;
    }

    /**
     * 获取权力比例
     *
     * @param qlblStr
     * @return
     */
    public static Double getGybl(String qlblStr) {
        Double qlbl = null;
        try {
            if (StringUtils.isNotBlank(qlblStr)) {
                if (qlblStr.indexOf(Constants.SIGN) > -1) {
                    qlblStr = qlblStr.replaceAll(Constants.SIGN, "");
                    qlbl = Double.parseDouble(qlblStr) / 100;
                } else if (qlblStr.indexOf(Constants.SPLIT_FS) > -1) {
                    //zhouwanqing 如果过度权利比例是分数，就会保留2位小数
                    String[] numbers = qlblStr.split(Constants.SPLIT_FS);
                    if (StringUtils.isNotBlank(numbers[0]) && StringUtils.isNotBlank(numbers[1]) && NumberUtils.isNumber(numbers[0]) && NumberUtils.isNumber(numbers[1])) {
                        if (!StringUtils.equals(numbers[1], "0")) {
                            BigDecimal b1 = new BigDecimal(numbers[0]);
                            BigDecimal b2 = new BigDecimal(numbers[1]);
                            qlbl= b1.divide(b2, 4, BigDecimal.ROUND_HALF_UP).doubleValue();
                        }
                    }
                } else {
                    if(isNumber(qlblStr)) {
                        qlbl = Double.parseDouble(qlblStr);
                        if (qlbl > 1)
                            qlbl = qlbl / 100;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return qlbl;
    }


    /**
     * 日起相减得出天数
     *
     * @param beginDateStr
     * @param endDateStr
     * @return
     */
    public static long getDaySub(Date beginDateStr, Date endDateStr) {
        long day = 0;
        if (beginDateStr != null && endDateStr != null) {
            day = (endDateStr.getTime() - beginDateStr.getTime()) / (24 * 60 * 60 * 1000);
            day = day + 1;
        }
        return day;
    }

    /**
     * 日起加天数得出新的日期
     *
     * @param SourceDate
     * @param day
     * @return
     */
    public static Date plusDay(Date SourceDate, int day) {
        SourceDate.setDate(SourceDate.getDate() + day);
        return SourceDate;
    }

    public static void write(byte[] data, OutputStream output)
            throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    /**
     * 从列表中获取数据
     *
     * @param baseDataList
     * @param entityClass
     * @return
     */
    public List<T> getDataFromList(List baseDataList, T entityClass) {
        List<T> getBaseDataList = new ArrayList<T>();
        if (CollectionUtils.isNotEmpty(baseDataList)) {
            for (Object baseData : baseDataList) {
                if (baseData != null && baseData.getClass().isInstance(entityClass)) {
                    getBaseDataList.add((T) baseData);
                }
            }
        }
        return getBaseDataList;
    }

    /**
     * 描述：zdd 该方法可以对list的对象中的某一个值排序。null排在最后
     *
     * @param list
     * @param method list对象中获取某一个值的方法
     * @param sort   sort="desc"时为倒叙，null为正序。
     */
    public static void sort(List list, final String method, final String sort) {
        try {
            Collections.sort(list, new Comparator() {
                public int compare(Object a, Object b) {
                    int ret = 0;
                    try {
                        Method m1 = ((Object) a).getClass().getMethod(method, null);
                        Method m2 = ((Object) b).getClass().getMethod(method, null);
                        Object object1 = new Object();
                        Object object2 = new Object();
                        //zdd 解决排序值为NULL的问题
                        if (m1.invoke(((Object) a), null) != null)
                            object1 = m1.invoke(((Object) a), null);
                        if (m2.invoke(((Object) b), null) != null)
                            object2 = m2.invoke(((Object) b), null);
                        //zdd 对日期型排序时，出现错乱，所以先将日期转换为字符型
                        if (object1 instanceof Date)
                            object1 = (Object) DateUtils.formatTime((Date) object1, DateUtils.DATETIME_FORMAT);
                        if (object2 instanceof Date)
                            object2 = (Object) DateUtils.formatTime((Date) object2, DateUtils.DATETIME_FORMAT);
                        if (sort != null && "desc".equals(sort)) {//倒序
                            if (object2 instanceof Integer && object1 instanceof Integer) {
                                ret = Integer.valueOf(object2.toString()).compareTo(Integer.valueOf(object1.toString()));
                            } else if (object2 instanceof Double && object1 instanceof Double) {
                                ret = Double.valueOf(object2.toString()).compareTo(Double.valueOf(object1.toString()));
                            } else {
                                ret = object2.toString().compareTo(object1.toString());
                            }
                        } else {    //正序
                            if (object2 instanceof Integer && object1 instanceof Integer) {
                                ret = Integer.valueOf(object1.toString()).compareTo(Integer.valueOf(object2.toString()));
                            } else if (object2 instanceof Double && object1 instanceof Double) {
                                ret = Double.valueOf(object1.toString()).compareTo(Double.valueOf(object2.toString()));
                            } else {
                                ret = object1.toString().compareTo(object2.toString());
                            }
                        }
                        //if (m2.invoke(((Object)b), null)!=null && m1.invoke(((Object)a), null)!=null){
                        //				    		if(sort != null && "desc".equals(sort)){//倒序
                        //					    		ret = m2.invoke(((Object)b), null).toString().compareTo(m1.invoke(((Object)a), null).toString());
                        //					    	}else{	//正序
                        //					    		ret = m1.invoke(((Object)a), null).toString().compareTo(m2.invoke(((Object)b), null).toString());
                        //					    	}
                        //}
                    } catch (NoSuchMethodException ne) {
                        System.out.println(ne);
                    } catch (IllegalAccessException ie) {
                        System.out.println(ie);
                    } catch (InvocationTargetException it) {
                        System.out.println(it);
                    }
                    return ret;
                }
            });
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
    }

    /**
     * 判断字符串是否是整数
     */
    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }

    /**
     * 判断字符串是否是浮点数
     */
    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            if (value.contains("."))
                return true;
            return false;
        } catch (NumberFormatException e) {
            return false;
        }
    }

    /**
     * 判断字符串是否是数字
     */
    public static boolean isNumber(String value) {
        return isInteger(value) || isDouble(value);
    }
}
