package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 登记受理申请信息
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "DJT_DJ_SLSQ")
public class DjtDjSlsq implements Serializable, AccessData {
    final static String ysdm = "6004010000";//要素代码
    private String ywh;//业务号
    private String djdl;//登记大类
    private String djxl;//登记小类
    private String qxdm;//区县代码
    private Integer sqzsbs;//申请证书板式
    private Integer sqfbcz;//申请分别持证
    private String slry;//受理人员
    private Date slsj;//受理时间
    private String zl;//坐落
    private String tzrxm;//通知人姓名
    private String tzfs;//通知方式
    private String tzrdh;//通知人电话
    private String tzryddh;//通知人移动电话
    private String tzrdzyj;//通知人电子邮件
    private String sfwtaj;//是否问题案件
    private Date jssj;//结束时间
    private String ajzt;//案件状态
    private String bz;//备注

    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "DJDL")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjdl() {
        return djdl;
    }

    public void setDjdl(String djdl) {
        this.djdl = djdl;
    }

    @XmlAttribute(name = "DJXL")
    public String getDjxl() {
        return djxl;
    }

    public void setDjxl(String djxl) {
        this.djxl = djxl;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "SQZSBS")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getSqzsbs() {
        return sqzsbs;
    }

    public void setSqzsbs(Integer sqzsbs) {
        this.sqzsbs = sqzsbs;
    }

    @XmlAttribute(name = "SQFBCZ")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getSqfbcz() {
        return sqfbcz;
    }

    public void setSqfbcz(Integer sqfbcz) {
        this.sqfbcz = sqfbcz;
    }

    @XmlAttribute(name = "SLRY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getSlry() {
        return slry;
    }

    public void setSlry(String slry) {
        this.slry = slry;
    }

    @XmlAttribute(name = "SLSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getSlsj() {
        return slsj;
    }

    public void setSlsj(Date slsj) {
        this.slsj = slsj;
    }

    @XmlAttribute(name = "ZL")
    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    @XmlAttribute(name = "TZRXM")
    public String getTzrxm() {
        return tzrxm;
    }

    public void setTzrxm(String tzrxm) {
        this.tzrxm = tzrxm;
    }

    @XmlAttribute(name = "TZFS")
    public String getTzfs() {
        return tzfs;
    }

    public void setTzfs(String tzfs) {
        this.tzfs = tzfs;
    }

    @XmlAttribute(name = "TZRDH")
    public String getTzrdh() {
        return tzrdh;
    }

    public void setTzrdh(String tzrdh) {
        this.tzrdh = tzrdh;
    }

    @XmlAttribute(name = "TZRYDDH")
    public String getTzryddh() {
        return tzryddh;
    }

    public void setTzryddh(String tzryddh) {
        this.tzryddh = tzryddh;
    }

    @XmlAttribute(name = "TZRDZYJ")
    public String getTzrdzyj() {
        return tzrdzyj;
    }

    public void setTzrdzyj(String tzrdzyj) {
        this.tzrdzyj = tzrdzyj;
    }

    @XmlAttribute(name = "SFWTAJ")
    public String getSfwtaj() {
        return sfwtaj;
    }

    public void setSfwtaj(String sfwtaj) {
        this.sfwtaj = sfwtaj;
    }

    @XmlAttribute(name = "JSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getJssj() {
        return jssj;
    }

    public void setJssj(Date jssj) {
        this.jssj = jssj;
    }

    @XmlAttribute(name = "AJZT")
    public String getAjzt() {
        return ajzt;
    }

    public void setAjzt(String ajzt) {
        this.ajzt = ajzt;
    }

    @XmlAttribute(name = "BZ")
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }
}
