/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.utils.ArrayUtils;
import cn.gtmap.estateplat.utils.Charsets;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;

public final class RequestUtils {
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
    public static UrlPathHelper URL_PATH_HELPER = new UrlPathHelper(){

        public String getLookupPathForRequest(HttpServletRequest request) {
            String key = request.getRequestURI() + "_lookupPath";
            String path = (String)request.getAttribute(key);
            if (path == null) {
                path = super.getPathWithinApplication(request);
                request.setAttribute(key, (Object)path);
            }
            return path;
        }
    };
    public static PathMatcher PATH_MATCHER = new AntPathMatcher();

    public static String getParameter(HttpServletRequest request, String name) {
        String query = request.getQueryString();
        if (query != null) {
            Matcher m = QUERY_PARAM_PATTERN.matcher(query);
            while (m.find()) {
                if (!name.equals(m.group(1))) continue;
                return m.group(3);
            }
        }
        return null;
    }

    public static String getClientIP(HttpServletRequest request) {
        String xForwardedFor = StringUtils.trimToNull((String)request.getHeader("$wsra"));
        if (xForwardedFor != null) {
            return xForwardedFor;
        }
        xForwardedFor = StringUtils.trimToNull((String)request.getHeader("X-Real-IP"));
        if (xForwardedFor != null) {
            return xForwardedFor;
        }
        xForwardedFor = StringUtils.trimToNull((String)request.getHeader("X-Forwarded-For"));
        if (xForwardedFor != null) {
            int spaceIndex = xForwardedFor.indexOf(44);
            if (spaceIndex > 0) {
                return xForwardedFor.substring(0, spaceIndex);
            }
            return xForwardedFor;
        }
        return request.getRemoteAddr();
    }

    public static String getDomain(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        int end = url.indexOf(".");
        if (end == -1) {
            return "";
        }
        int start = url.indexOf("//");
        return url.substring(start + 2, end);
    }

    public static String toJSON(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static String formatUrl(String base, String path) {
        StringBuilder sb = new StringBuilder();
        if (!"/".equals(base)) {
            sb.append(base);
        }
        if (path.charAt(0) != '/') {
            sb.append("/");
        }
        sb.append(path);
        return sb.toString();
    }

    public static String buildUrl(String path, Map<?, ?> args) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        String url = path.startsWith("/") ? "" : path;
        StringBuilder sb = new StringBuilder(url);
        boolean isFirst = true;
        if (args != null) {
            for (Map.Entry<?, ?> entry : args.entrySet()) {
                boolean isFirst1;
                if (isFirst) {
                    isFirst = false;
                    sb.append(url.contains("?") ? "&" : "?");
                } else {
                    sb.append("&");
                }
                String key = RequestUtils.encode(entry.getKey());
                Object value = entry.getValue();
                if (value == null) {
                    sb.append(key);
                    continue;
                }
                if (value instanceof Iterable) {
                    isFirst1 = true;
                    for (Object value1 : (Iterable)value) {
                        if (isFirst1) {
                            isFirst1 = false;
                        } else {
                            sb.append("&");
                        }
                        sb.append(key).append("=").append(RequestUtils.encode(value1));
                    }
                    continue;
                }
                if (value.getClass().isArray()) {
                    isFirst1 = true;
                    for (Object value1 : (Object[])value) {
                        if (isFirst1) {
                            isFirst1 = false;
                        } else {
                            sb.append("&");
                        }
                        sb.append(key).append("=").append(RequestUtils.encode(value1));
                    }
                    continue;
                }
                sb.append(key).append("=").append(RequestUtils.encode(value));
            }
        }
        return sb.toString();
    }

    public static String encode(Object url) {
        try {
            return URLEncoder.encode(url.toString(), Charsets.UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AppException(e);
        }
    }

    public static String decode(String url) {
        try {
            return URLEncoder.encode(url, Charsets.UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AppException(e);
        }
    }

    public static boolean isPost(HttpServletRequest request) {
        return "POST".equals(request.getMethod());
    }

    public static boolean matchAny(HttpServletRequest request, UrlPathHelper urlPathHelper, PathMatcher pathMatcher, String[] patterns) {
        if (ArrayUtils.isNotEmpty((Object[])patterns)) {
            String lookupPath = urlPathHelper.getLookupPathForRequest(request);
            for (String pattern : patterns) {
                if (!pathMatcher.match(pattern, lookupPath)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchAll(HttpServletRequest request, UrlPathHelper urlPathHelper, PathMatcher pathMatcher, String[] patterns) {
        if (ArrayUtils.isNotEmpty((Object[])patterns)) {
            String lookupPath = urlPathHelper.getLookupPathForRequest(request);
            for (String pattern : patterns) {
                if (pathMatcher.match(pattern, lookupPath)) continue;
                return false;
            }
        }
        return true;
    }

    public static String getString(HttpServletRequest request, String name) {
        return request.getParameter(name);
    }

    public static String getString(HttpServletRequest request, String name, String def) {
        String value = RequestUtils.getString(request, name);
        return StringUtils.isEmpty((CharSequence)value) ? def : value;
    }

    public static Boolean getBool(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        return StringUtils.isEmpty((CharSequence)value) ? null : BooleanUtils.toBooleanObject((String)value);
    }

    public static boolean getBool(HttpServletRequest request, String name, boolean def) {
        Boolean value = RequestUtils.getBool(request, name);
        return value == null ? def : value;
    }

    public static Integer getInt(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        return StringUtils.isEmpty((CharSequence)value) ? null : NumberUtils.createInteger((String)value);
    }

    public static int getInt(HttpServletRequest request, String name, int def) {
        Integer value = RequestUtils.getInt(request, name);
        return value == null ? def : value;
    }

    public static Double getDouble(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        return StringUtils.isEmpty((CharSequence)value) ? null : NumberUtils.createDouble((String)value);
    }

    public static double getDouble(HttpServletRequest request, String name, double def) {
        Double value = RequestUtils.getDouble(request, name);
        return value == null ? def : value;
    }
}

