package cn.gtmap.estateplat.service.employment.subject;

import cn.gtmap.estateplat.model.employment.subject.FcjyCyztCyqyjbxx;
import cn.gtmap.estateplat.model.employment.subject.FcjyCyztCyryjbxx;

import java.util.List;

/**
 * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
 * @version 1.0, 2017/12/8
 * @description
 */
public interface FcjyCyztRemoteService {
    /**
     * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
     * @param userid 用户id
     * @return FcjyCyztCyqyjbxx 从业企业基本信息
     * @description 从业企业查询接口
     */
    FcjyCyztCyqyjbxx getCyztQyxxByUserid(String userid);

    /**
     * @author <a href="mailto:haibingshuai@gtmap.cn">haibingshuai</a>
     * @param qylxdm 企业类型代码
     * @return FcjyCyztCyqyjbxx 从业企业基本信息
     * @description 所有从业企业查询接口
     */
    List<FcjyCyztCyqyjbxx> getCyztQyxxList(String qylxdm);


    /**
     * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
     * @param uesrid 用户id
     * @return FcjyCyztCyryjbxx 从业人员基本信息
     * @description 从业人员查询接口
     */
    FcjyCyztCyryjbxx getCyztRyxxByUserid(String uesrid);

    /**
     * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
     * @param qybh 企业编号
     * @return FcjyCyztCyryjbxx 从业企业基本信息
     * @description 获取某个企业所有的从业人员
     */
    List<FcjyCyztCyryjbxx> getCyztRyxxByQybh(String qybh);

    /**
     * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
     * @param qybh 企业编号
     * @return FcjyCyztCyqyjbxx
     * @description 根据企业编号获取企业
     */
    FcjyCyztCyqyjbxx getCyztQyxxByQybh(String qybh);

    /**
     * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
     * @param rybh 人员编号
     * @return FcjyCyztCyryjbxx
     * @description 根据人员编号获取人员信息
     */
    FcjyCyztCyryjbxx getCyztRyxxByRybh(String rybh);
}
