package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.national.DataModel;

/**
 * 获取国家级平台接入xml
 *
 * @author <a href="mailto:shenjian@gtmap.cn">jane</a>
 * @version 1.0, 2015/11/16
 */
public interface NationalAccessXmlService {
    /**
     * 当前业务编码
     *
     * @return
     */
    String getRecType();

    /**
     * 根据业务号获取接入国家级平台xml数据
     *
     * @param ywh 登记系统业务号
     * @return
     */
    @Deprecated
    String getAccessXMLData(String ywh);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param ywh 登记系统业务号
     * @param bdcdyh 不动产单元号
     * @rerutn
     * @description 根据业务号和不动单元号获取接入国家级平台xml数据（海门版本）
     */
    @Deprecated
    String getAccessXMLData(String ywh,String bdcdyh);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param ywh
     * @rerutn
     * @description 根据业务号获取数据
     */
    DataModel getAccessDataModel(String ywh);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param ywh
     * @rerutn
     * @description 根据业务号和不动产单元号获取国家级接入平台Model数据
     */
    DataModel getNationalAccessDataModel(String ywh, String bdcdyh);
}
