package cn.gtmap.estateplat.model.exchange.share;

import com.alibaba.fastjson.annotation.JSONField;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlType;
import java.util.Date;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018-1-12
 * @description 全城通办收件信息
 */
@Entity
@Table(name = "gx_qctb_sjxx")
@XmlType(propOrder = {"sjxxid", "xmid", "sjrq", "sjrmc"})
public class GxQctbSjxx {
    @Id
    private String sjxxid;//收件信息ID（主键）
    private String xmid;//项目ID
    @JSONField(format = "yyyy-MM-dd HH:mm:ss.SSS")
    private Date sjrq;//收件日期
    private String sjrmc;//收件人名称

    public String getSjxxid() {
        return sjxxid;
    }

    public void setSjxxid(String sjxxid) {
        this.sjxxid = sjxxid;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public Date getSjrq() {
        return sjrq;
    }

    public void setSjrq(Date sjrq) {
        this.sjrq = sjrq;
    }

    public String getSjrmc() {
        return sjrmc;
    }

    public void setSjrmc(String sjrmc) {
        this.sjrmc = sjrmc;
    }
}
