package cn.gtmap.estateplat.core.support.mybatis.mapper;

import org.apache.commons.beanutils.Converter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/6/16
 * @description Clob类型转换器
 */
public class ClobConvert implements Converter {

    public Object convert(Class arg0, Object arg1) {
        String p = null;
        if (arg1 == null)
            return null;
        if(arg1 instanceof Clob){
            /**
             *    Clob处理
             */
            Reader is = null;
            BufferedReader br = null;
            try {
                is = ((Clob)arg1).getCharacterStream();
                br = new BufferedReader(is);
                String s = br.readLine();
                StringBuffer sb = new StringBuffer();
                while (s != null) {
                    /**
                     *   执行循环将字符串全部取出付值给StringBuffer由StringBuffer转成STRING
                     */
                    sb.append(s);
                    s = br.readLine();
                }

                p  = sb.toString();
            } catch (SQLException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }finally {
                try {
                    if(br!=null)
                        br.close();
                    if(is!=null)
                        is.close();
                }catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }else {
            p = arg1.toString();
            if (p == null || p.trim().length() == 0) {
                return null;
            }
        }

        return p;
    }

}