package cn.gtmap.estateplat.core.support.mybatis.page.model;


import java.lang.annotation.*;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">jane</a>
 * @version 1.0, 2015/12/5
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface PageDefault {
    /**
     * 页大小
     */
    int value() default 10;

    /**
     * 页号
     */
    int index() default 0;

    /**
     * 位置
     */
    int offset() default 0;

    /**
     * 排序,语法同sql,如:
     * name asc,age desc
     * id
     */
    String sort() default "";

    /**
     * 参数前缀,如user,则传递参数为user_size,user_index,user_offset;
     */
    String prefix() default "";
}
