/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.AliyunSmsService;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.BatchSmsAttributes;
import com.aliyun.mns.model.MessageAttributes;
import com.aliyun.mns.model.RawTopicMessage;
import com.aliyun.mns.model.TopicMessage;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AliyunSmsServiceImpl
implements AliyunSmsService {
    private static final String PHONE_NUMBER_NULL = "\u7535\u8bdd\u53f7\u7801\u4e3a\u7a7a\uff01";
    private static final String CONTENT_NUMBER_NULL = "\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a\uff01";
    private static final String ALI_ACCOUNT_NULL = "\u963f\u91cc\u4e91\u8d26\u53f7\u4e3a\u7a7a\uff01";
    private static final String ALI_ACCOUNT_KEY_NULL = "\u963f\u91cc\u4e91\u8d26\u53f7\u79d8\u94a5\u4e3a\u7a7a\uff01";
    private static final String ENDPOINT_NULL = "MNS\u7684\u63a5\u5165\u5730\u5740\u4e3a\u7a7a\uff01";
    private static final String TOPICNAME_NULL = "\u4e3b\u9898\u540d\u79f0\u4e3a\u7a7a\uff01";
    private static final String SIGNNAME_NULL = "\u77ed\u4fe1\u7b7e\u540d\u540d\u79f0\u4e3a\u7a7a\uff01";
    private String accessId;
    private String accessKey;
    private String endpoint;
    private String topicName;
    private String signName;
    private String smsCode;

    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getSmsCode() {
        return this.smsCode;
    }

    public void setSmsCode(String smsCode) {
        this.smsCode = smsCode;
    }

    @Override
    public void sendSms(Map<String, String> paramMap, String receiveNum) {
        if (StringUtils.isBlank((CharSequence)receiveNum)) {
            throw new AppException(PHONE_NUMBER_NULL);
        }
        if (StringUtils.isBlank((CharSequence)this.smsCode)) {
            throw new AppException(CONTENT_NUMBER_NULL);
        }
        if (StringUtils.isBlank((CharSequence)this.accessId)) {
            throw new AppException(ALI_ACCOUNT_NULL);
        }
        if (StringUtils.isBlank((CharSequence)this.accessKey)) {
            throw new AppException(ALI_ACCOUNT_KEY_NULL);
        }
        if (StringUtils.isBlank((CharSequence)this.endpoint)) {
            throw new AppException(ENDPOINT_NULL);
        }
        if (StringUtils.isBlank((CharSequence)this.topicName)) {
            throw new AppException(TOPICNAME_NULL);
        }
        if (StringUtils.isBlank((CharSequence)this.signName)) {
            throw new AppException(SIGNNAME_NULL);
        }
        CloudAccount account = new CloudAccount(this.accessId, this.accessKey, this.endpoint);
        MNSClient client = account.getMNSClient();
        CloudTopic topic = client.getTopicRef(this.topicName);
        RawTopicMessage msg = new RawTopicMessage();
        msg.setMessageBody("sms-message");
        MessageAttributes messageAttributes = new MessageAttributes();
        BatchSmsAttributes batchSmsAttributes = new BatchSmsAttributes();
        batchSmsAttributes.setFreeSignName(this.signName);
        batchSmsAttributes.setTemplateCode(this.smsCode);
        BatchSmsAttributes.SmsReceiverParams smsReceiverParams = new BatchSmsAttributes.SmsReceiverParams();
        if (MapUtils.isNotEmpty(paramMap)) {
            for (String key : paramMap.keySet()) {
                smsReceiverParams.setParam(key, paramMap.get(key));
            }
        }
        batchSmsAttributes.addSmsReceiver(receiveNum, smsReceiverParams);
        messageAttributes.setBatchSmsAttributes(batchSmsAttributes);
        try {
            TopicMessage ret = topic.publishMessage(msg, messageAttributes);
            System.out.println("MessageId: " + ret.getMessageId());
            System.out.println("MessageMD5: " + ret.getMessageBodyMD5());
        }
        catch (ServiceException se) {
            System.out.println(se.getErrorCode() + se.getRequestId());
            System.out.println(se.getMessage());
            se.printStackTrace();
            throw new AppException(se.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException(e.getMessage());
        }
        client.close();
    }
}

