package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import org.springframework.data.domain.Pageable;

/**
 * 原房屋或者土地登记信息分页信息接口
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2015/11/28
 */
public interface QzYwxxPageService {


    /**
     * 根据分页请求和参数返回标准过渡库中登记项目业务信息
     * @param pageable
     * @param parameters
     * @param <T>
     * @return
     */
    public <T> Page<T> getQzYwxxPage(Pageable pageable,Object parameters);

    /**
     * 根据分页请求参数和查询参数返回房屋登记信息page对象
     * @param pageable 分页请求参数
     * @param parameters 查询参数
     * @param <T>
     * @return
     */
    public <T> Page<T> getQzFwYwxxPage(Pageable pageable,Object parameters);

    /**
     * 根据分页请求参数和查询参数返回土地登记信息page对象
     * @param pageable 分页请求参数
     * @param parameters 查询参数
     * @param <T>
     * @return
     */
    public <T> Page<T> getQzTdYwxxPage(Pageable pageable,Object parameters);

    /**
     * 根据分页请求参数和查询参数返回草地登记信息page对象
     * @param pageable 分页请求参数
     * @param parameters 查询参数
     * @param <T>
     * @return
     */
    public <T> Page<T> getQzCdYwxxPage(Pageable pageable,Object parameters);

    /**
     * 根据分页请求参数和查询参数返回林地登记信息page对象
     * @param pageable 分页请求参数
     * @param parameters 查询参数
     * @param <T>
     * @return
     */
    public <T> Page<T> getQzLdYwxxPage(Pageable pageable,Object parameters);

    /**
     * 根据分页请求参数和查询参数返回海域登记信息page对象
     * @param pageable 分页请求参数
     * @param parameters 查询参数
     * @param <T>
     * @return
     */
    public <T> Page<T> getQzHyYwxxPage(Pageable pageable,Object parameters);
}
