/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ArrayUtils
extends org.apache.commons.lang3.ArrayUtils {
    public static String[] subarray(String[] array, int startIndex) {
        if (array == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (startIndex <= 0) {
            return array;
        }
        int newSize = array.length - startIndex;
        if (newSize <= 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] subArray = new String[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static <T> T[] subarray(T[] array, int startIndex) {
        if (array == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (startIndex <= 0) {
            return array;
        }
        int newSize = array.length - startIndex;
        if (newSize <= 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Class<?> type = array.getClass().getComponentType();
        Object[] subArray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static <T> List<T> asList(T ... a) {
        return a == null ? Collections.emptyList() : Arrays.asList(a);
    }

    private ArrayUtils() {
    }
}

