package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 登记审核信息
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "DJF_DJ_SH")
public class DjfDjSh implements Serializable, AccessData {
    final static String ysdm = "6004050000";//要素代码
    private String ywh;//业务号
    private String jdmc;//节点名称
    private Integer sxh;//顺序号
    private String shryxm;//审核人员姓名
    private Date shkssj;//审核开始时间
    private Date shjssj;//审核结束时间
    private String shyj;//审核意见
    private String czjg;//操作结果
    private String qxdm;//区县代码

    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "JDMC")
    public String getJdmc() {
        return jdmc;
    }

    public void setJdmc(String jdmc) {
        this.jdmc = jdmc;
    }

    @XmlAttribute(name = "SXH")
    public Integer getSxh() {
        return sxh;
    }

    public void setSxh(Integer sxh) {
        this.sxh = sxh;
    }

    @XmlAttribute(name = "SHRYXM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getShryxm() {
        return shryxm;
    }

    public void setShryxm(String shryxm) {
        this.shryxm = shryxm;
    }

    @XmlAttribute(name = "SHKSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getShkssj() {
        return shkssj;
    }

    public void setShkssj(Date shkssj) {
        this.shkssj = shkssj;
    }

    @XmlAttribute(name = "SHJSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getShjssj() {
        return shjssj;
    }

    public void setShjssj(Date shjssj) {
        this.shjssj = shjssj;
    }

    @XmlAttribute(name = "SHYJ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getShyj() {
        return shyj;
    }

    public void setShyj(String shyj) {
        this.shyj = shyj;
    }

    @XmlAttribute(name = "CZJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getCzjg() {
        return czjg;
    }

    public void setCzjg(String czjg) {
        this.czjg = czjg;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }
}
