package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.Charsets;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/5/4
 * @description 中国联通短信服务
 */
public class CuccSmsServiceImpl implements SmsService {
    private final static String SMS_RESULT_DESCRIPTION="短信发送失败！";
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description httpclient
     */
    private HttpClient httpClient;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 企业编号
     */
    private String spCode;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 用户名
     */
    private String username;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 密码
     */
    private String password;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description sms服务url
     */
    private String smsUrl;

    public HttpClient getHttpClient() {
        return httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getSpCode() {
        return spCode;
    }

    public void setSpCode(String spCode) {
        this.spCode = spCode;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSmsUrl() {
        return smsUrl;
    }

    public void setSmsUrl(String smsUrl) {
        this.smsUrl = smsUrl;
    }

    /**
     * @param phoneNum 手机号
     * @param content  内容
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 发送短信
     */
    @Override
    public Boolean sendSms(String phoneNum, String content) throws AppException {
        HttpPost httpPost = new  HttpPost(smsUrl);
        List<BasicNameValuePair> params = Lists.newArrayList();
        params.add(new BasicNameValuePair("SpCode", spCode));
        params.add(new BasicNameValuePair("LoginName", username));
        params.add(new BasicNameValuePair("Password", password));
        params.add(new BasicNameValuePair("MessageContent", content));
        params.add(new BasicNameValuePair("UserNumber", phoneNum));
        params.add(new BasicNameValuePair("SerialNumber", CalendarUtil.getTimeMs()));
        params.add(new BasicNameValuePair("ScheduleTime", ""));
        params.add(new BasicNameValuePair("ExtendAccessNum", ""));
        params.add(new BasicNameValuePair("f", "1"));
        UrlEncodedFormEntity urlEncodedFormEntity;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(params, Charsets.CHARSET_GBK);
            httpPost.setEntity(urlEncodedFormEntity);
            HttpResponse httpResponse = httpClient.execute(httpPost);
            HttpEntity entity = httpResponse.getEntity();
            String info = EntityUtils.toString(entity);
            Boolean smsResult = false;
            String smsDescription=SMS_RESULT_DESCRIPTION;
            if(StringUtils.isNotBlank(info)){
                List<org.apache.http.NameValuePair> resultList = URLEncodedUtils.parse(info, Charsets.CHARSET_GBK);
                for(org.apache.http.NameValuePair result:resultList){
                    if("result".equals(result.getName())&&"0".equals(result.getValue())){
                        smsResult = true;
                        break;
                    }
                    if("description".equals(result.getName()))
                        smsDescription = result.getValue();
                }
            }
            if(!smsResult)
                throw new AppException(smsDescription);
        } catch (IOException e) {
            new AppException(e);
        }
        return null;
    }
}
