package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import com.linkage.netmsg.NetMsgclient;

import java.io.IOException;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/5/4
 * @description 中国电信短信服务
 */
public class CtccSmsServiceImpl implements SmsService {
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 服务器IP
     */
    private String serverIp;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 服务器端口
     */
    private Integer serverPort;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 用户名
     */
    private String username;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 密码
     */
    private String password;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 企业标示ID
     */
    private Integer enterpriseId;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 来源电话号码
     */
    private String srcPhone;

    public String getServerIp() {
        return serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public Integer getServerPort() {
        return serverPort;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(Integer enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getSrcPhone() {
        return srcPhone;
    }

    public void setSrcPhone(String srcPhone) {
        this.srcPhone = srcPhone;
    }

    /**
     * @param phoneNum 手机号
     * @param content  内容
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 发送短信
     */

    @Override
    public Boolean sendSms(String phoneNum, String content){
        NetMsgclient netMsgclient = null;
        try {
            netMsgclient = new NetMsgclient();
            netMsgclient.connect(serverIp, serverPort);
            if(netMsgclient.msgRequest(username, password)){
                if (netMsgclient.recordLDF(enterpriseId,srcPhone,phoneNum,content) != 0)
                    return false;
            }
        } catch (Exception ex) {
            try{
                netMsgclient.forceDisconnect();
            }catch(Exception e){
                new AppException(e);
            }
            new AppException(ex);
        } finally {
            if(netMsgclient!=null) {
                try {
                    netMsgclient.disconnect();
                } catch (IOException e) {
                    new AppException(e);
                }
            }
        }
        return  true;
    }

    private String getSmsError(int errorCode) {
        switch (errorCode) {
            case 1:
                return "系统错误";
            case 2:
                return "帐号错误";
            case 3:
                return "密码错误";
            case 4:
                return "连接数超过限制";
            case 5:
                return "秒发送条目数超过限制";
            case 6:
                return "目的号码受限制";
            case 7:
                return "网络错误";
            case 8:
                return "月发送条目数超过限制";
            case 9:
                return "客户端关闭连接";
            case 10:
                return "短信网关关闭连接";
            case 11:
                return "超时退出";
            case 12:
                return "连接数据库错误";
            case 13:
                return "连接短信网关错误";
            case 14:
                return "非法发送内容";
            case 15:
                return "非法发送时间";
            default:
                return "系统错误";
        }
    }
}
