package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.transition.QzQlr;

import java.util.List;

/**
 * 权利人接口
 *
 * @author <a href="mailto: lijian@gtmap.cn">lj</a>
 * @version 1.0 15-11-19
 */
public interface QzQlrService {
    /**
     * 通过权利人编号和表名（视图名）获取权利人
     *
     * @param qlrbh
     * @param table
     * @return
     */
    public QzQlr getQzqlrByQlrbh(String qlrbh, String table);

    /**
     * 通过权利编号获取权利人
     *
     * @param qlbh
     * @param table
     * @return
     */
    public List<QzQlr> getQzqlrsByQlbh(String qlbh, String table);

    /**
     * 通过不动产单元编号获取权利人
     *
     * @param bdcdybh
     * @param table
     * @return
     */
    public List<QzQlr> getQzqlrsByBdcdybh(String bdcdybh, String table);
}
