package cn.gtmap.estateplat.core.support.mybatis.page.model;


import cn.gtmap.estateplat.utils.Constants;
import com.alibaba.fastjson.annotation.JSONField;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.domain.Pageable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


/**
 * Date Created 2014-2-26
 *
 * @author loafer[zjh527@gmail.com]
 * @version 1.0
 */
public class PageImpl<T> implements Page<T>, Serializable {
    private final List<T> rows = new ArrayList<T>();
    //总页数
    private final int total;
    //总记录数
    private final int records;
    //当前页
    private final int page;
    //每页显示记录数
    private final int pageSize;
    //状态码
    private final int status;

    public PageImpl(Collection<? extends T> content, int page, int total, int limit) {
        this.rows.addAll(content);
        this.records = total;
        this.page = page;
        this.pageSize = limit;
        if (CollectionUtils.isNotEmpty(content)) {
            if (total % limit == 0)
                this.total = total / limit;
            else
                this.total = total / limit + 1;
        } else {
            this.total = 1;
        }
        this.status = Constants.STATUS_OK;
    }

    public PageImpl(Collection<? extends T> content, int total, Pageable pageable) {
        this.rows.addAll(content);
        this.records = total;
        this.page = pageable.getPageNumber() + 1;
        this.pageSize = pageable.getPageSize();
        if (pageable.getPageSize() < 0) {
            this.total = 0;
        } else {
            int count = (int) (total / pageable.getPageSize());
            this.total = total % (pageable.getPageSize()) != 0 ? count + 1 : count;
        }
        this.status = Constants.STATUS_OK;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getRecords() {
        return this.records;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    @JSONField(serialize = false)
    public int getItemSize() {
        return getRows().size();
    }

    @Override
    public List<T> getRows() {
        return this.rows;
    }

    @Override
    public T getRow(int index) {
        return this.rows.get(index);
    }

    @Override
    public int getStatus() {
        return this.status;
    }
}
