/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final FastDateFormat JDK_TIME_FORMAT = FastDateFormat.getInstance((String)"EEE MMM dd HH:mm:ss zzz yyyy", (Locale)Locale.US);
    public static final FastDateFormat DATETIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    public static final FastDateFormat DATEMIN_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm");
    public static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final List<FastDateFormat> CUSTOM_FORMATS = Lists.newArrayList((Object[])new FastDateFormat[]{JDK_TIME_FORMAT});
    public static final Date ZERO = new Date(0L);
    public static final long START_SECOND = 1402400000L;
    private static Pattern NUMBERS = Pattern.compile("^[0-9]+$");
    private static Pattern DAYS = Pattern.compile("^([0-9]+)d$");
    private static Pattern HOURS = Pattern.compile("^([0-9]+)h$");
    private static Pattern MINUTES = Pattern.compile("^([0-9]+)m$");
    private static Pattern SECONDS = Pattern.compile("^([0-9]+)s$");
    private static Pattern MILLISECONDS = Pattern.compile("^([0-9]+)ms$");

    public static void registerFormat(String format) {
        CUSTOM_FORMATS.add(FastDateFormat.getInstance((String)format));
    }

    public static void registerFormat(String format, TimeZone timeZone) {
        CUSTOM_FORMATS.add(FastDateFormat.getInstance((String)format, (TimeZone)timeZone));
    }

    public static void registerFormat(String format, TimeZone timeZone, Locale locale) {
        CUSTOM_FORMATS.add(FastDateFormat.getInstance((String)format, (TimeZone)timeZone, (Locale)locale));
    }

    public static Date parse(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            String strVal = ((String)value).trim();
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.indexOf(45) != -1) {
                FastDateFormat format;
                switch (strVal.length()) {
                    case 10: {
                        format = DATE_FORMAT;
                        break;
                    }
                    case 16: {
                        format = DATEMIN_FORMAT;
                        break;
                    }
                    case 19: {
                        format = strVal.indexOf(84) > -1 ? DateFormatUtils.ISO_DATETIME_FORMAT : DATETIME_FORMAT;
                        break;
                    }
                    default: {
                        format = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT;
                    }
                }
                try {
                    return format.parse(strVal);
                }
                catch (ParseException parseException) {
                }
            } else {
                try {
                    return new Date(Long.parseLong(strVal));
                }
                catch (NumberFormatException format) {
                    // empty catch block
                }
            }
            for (FastDateFormat fdf : CUSTOM_FORMATS) {
                try {
                    return fdf.parse(strVal);
                }
                catch (ParseException parseException) {
                }
            }
        }
        throw new IllegalArgumentException("Can not cast to Date, value : " + value);
    }

    public static Date now() {
        return new Date();
    }

    public static long toShortSecond(long timestamp) {
        return timestamp / 1000L - 1402400000L;
    }

    public static long toNormalSecond(long shortSecond) {
        return 1402400000L + shortSecond;
    }

    public static long getCurrentShortSecond() {
        return DateUtils.toShortSecond(System.currentTimeMillis());
    }

    public static long parseDuration(String duration) {
        if (duration == null) {
            return 2592000000L;
        }
        if (NUMBERS.matcher(duration).matches()) {
            return (long)Integer.parseInt(duration) * 1000L;
        }
        Matcher matcher = SECONDS.matcher(duration);
        if (matcher.matches()) {
            return (long)Integer.parseInt(matcher.group(1)) * 1000L;
        }
        matcher = MINUTES.matcher(duration);
        if (matcher.matches()) {
            return (long)Integer.parseInt(matcher.group(1)) * 60000L;
        }
        matcher = HOURS.matcher(duration);
        if (matcher.matches()) {
            return (long)Integer.parseInt(matcher.group(1)) * 3600000L;
        }
        matcher = DAYS.matcher(duration);
        if (matcher.matches()) {
            return (long)Integer.parseInt(matcher.group(1)) * 86400000L;
        }
        matcher = MILLISECONDS.matcher(duration);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new IllegalArgumentException("Invalid duration pattern : " + duration);
    }

    public static String formatTime(Date date, FastDateFormat fastDateFormat) {
        return fastDateFormat.format(date);
    }
}

