/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class JwtUtil {
    public static Claims parseJWT(String jsonWebToken, String base64Security) {
        try {
            Claims claims = null;
            JwtParser jwtParser = Jwts.parser();
            if (StringUtils.isNotBlank((CharSequence)base64Security)) {
                jwtParser.setSigningKey(base64Security.getBytes());
            }
            claims = (Claims)jwtParser.parseClaimsJws(jsonWebToken).getBody();
            return claims;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String createJWT(Map<String, Object> claimMap, SignatureAlgorithm signature, long TTLMillis, String base64Security) {
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"njgt");
        if (claimMap != null && claimMap.size() > 0) {
            for (String key : claimMap.keySet()) {
                builder.claim(key, claimMap.get(key));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)base64Security)) {
            SignatureAlgorithm signatureAlgorithm = null;
            signatureAlgorithm = signature == null || signature == SignatureAlgorithm.NONE ? SignatureAlgorithm.HS256 : signature;
            byte[] apiKeySecretBytes = base64Security.getBytes();
            SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
            builder.signWith(signatureAlgorithm, (Key)signingKey);
        }
        if (TTLMillis > 0L) {
            long expMillis = nowMillis + TTLMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp).setNotBefore(now);
        }
        return builder.compact();
    }
}

