package cn.gtmap.estateplat.service.exchange;

import java.util.HashMap;
import java.util.List;

/**
 * Created by zdd on 2015/12/10.
 * 查询单个过渡数据集的服务
 */
public interface QzDataService {

    /**
     * zdd 根据业务号查询单个种类的对象
     * @param entityClass
     * @param ywh
     * @param <T> 后续完善  统一定义一个含有ywh的抽象类
     * @return
     */
    <T> List<T> queryQzData(Class<T> entityClass, String ywh);
    /**
     * zhx 根据Map对象查询单个种类的对象
     * @param entityClass
     * @param map
     * @param <T>
     * @return
     */
    <T> List<T> queryQzDataByMap(Class<T> entityClass, HashMap map);

    /**
     * zdd 插入或更新对象
     * @param qzData 过渡数据库中的对象
     * @param <T>
     * @return
     */
    <T> int saveOrUpdateQzData(T qzData);

    /**
     * zdd 删除qzData
     * @param qzData
     * @param <T>
     * @return
     */
    <T> int delQzData(T qzData);

    /**
     * zdd 根据主键 删除
     * @param entityClass
     * @param key
     * @param <T>
     * @return
     */
    <T> int deleteByPrimaryKey(Class<T> entityClass, Object key);
}
