package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.MasSmsService;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.csapi.schema.sms.*;
import org.csapi.service.CmccMasWbs;
import org.csapi.service.CmccMasWbs_Service;
import org.csapi.service.PolicyException;
import org.csapi.service.ServiceException;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2017/10/18
 * @description 中国移动服务--张家港
 */
public class CmccSmsServiceForZjgImpl implements MasSmsService {

    private CmccMasWbs cmccMasWbs;

    private String applicationID;

    public void setApplicationID(String applicationID) {
        this.applicationID = applicationID;
    }

    public void initMasSmsService() {
        if(StringUtils.isNotBlank(AppConfig.getProperty("sms.url"))){
            URL smsUrl = null;
            try {
                smsUrl = new URL(AppConfig.getProperty("sms.url"));
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }

            CmccMasWbs_Service cmccMasWbs_service = new CmccMasWbs_Service(smsUrl);
            cmccMasWbs = cmccMasWbs_service.getCmccMasWbs();

        }
    }

    @Override
    public String sendSms(String phoneNum, String content) throws AppException {
        String requestIdentifier = StringUtils.EMPTY;
        if (StringUtils.isNoneBlank(phoneNum, content, applicationID) && cmccMasWbs != null) {
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setApplicationID(applicationID);
            sendSmsRequest.setExtendCode(null);
            List<String> destinationAddressesList = sendSmsRequest.getDestinationAddresses();
            destinationAddressesList.addAll(Arrays.asList(StringUtils.split(phoneNum, ",")));
            sendSmsRequest.setMessageFormat(MessageFormat.GB_18030);
            sendSmsRequest.setMessage(content);
            sendSmsRequest.setSendMethod(SendMethodType.LONG);
            sendSmsRequest.setDeliveryResultRequest(true);
            try {
                SendSmsResponse sendSmsResponse = cmccMasWbs.sendSms(sendSmsRequest);
                if (sendSmsResponse != null) {
                    requestIdentifier = sendSmsResponse.getRequestIdentifier();
                }
            } catch (ServiceException e) {
                e.printStackTrace();
            } catch (PolicyException e) {
                e.printStackTrace();
            }
        }
        return requestIdentifier;
    }

    @Override
    public Boolean getStatus(String requestIdentifier) {
        Boolean flag = false;
        GetSmsDeliveryStatusRequest getSmsDeliveryStatusRequest = new GetSmsDeliveryStatusRequest();
        getSmsDeliveryStatusRequest.setApplicationID(applicationID);
        getSmsDeliveryStatusRequest.setRequestIdentifier(requestIdentifier);
        try {
            if(cmccMasWbs != null){
                GetSmsDeliveryStatusResponse getSmsDeliveryStatusResponse = cmccMasWbs.getSmsDeliveryStatus(getSmsDeliveryStatusRequest);
                if (getSmsDeliveryStatusResponse != null) {
                    List<DeliveryInformation> deliveryInformationList = getSmsDeliveryStatusResponse.getItem();
                    if (CollectionUtils.isNotEmpty(deliveryInformationList)) {
                        for (DeliveryInformation deliveryInformation : deliveryInformationList) {
                            if (DeliveryStatus.DELIVERY_TO_TERMINAL.equals(deliveryInformation.getDeliveryStatus())) {
                                flag = true;
                                break;
                            }
                        }
                    }
                }
            }
        } catch (ServiceException e) {
            e.printStackTrace();
        } catch (PolicyException e) {
            e.printStackTrace();
        }
        return flag;
    }
}
