package cn.gtmap.estateplat.model.exchange.national;


import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Date;

/**
 * 非结构化文档
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "FJ_F_100")
public class FjF implements Serializable, AccessData {
    private String ywh;//业务号
    private String fjmc;//附件名称
    private String fjlx;//附件类型
    private String fjnr;//附件内容，Base64位编码格式
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 附件内容，blob类型格式
     */
    private byte[] fjnrblob;

    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @description 附件内容 文件中心地址
     */
    private String fjnrUrl;


    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "FJMC")
    public String getFjmc() {
        return fjmc;
    }

    public void setFjmc(String fjmc) {
        this.fjmc = fjmc;
    }

    @XmlAttribute(name = "FJLX")
    public String getFjlx() {
        return fjlx;
    }

    public void setFjlx(String fjlx) {
        this.fjlx = fjlx;
    }

    @XmlAttribute(name = "FJNR")
    public String getFjnr() {
        return fjnr;
    }

    public void setFjnr(String fjnr) {
        this.fjnr = fjnr;
    }

    @XmlTransient
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlTransient
    public byte[] getFjnrblob() {
        return fjnrblob;
    }

    public void setFjnrblob(byte[] fjnrblob) {
        this.fjnrblob = fjnrblob;
    }

    @XmlTransient
    public String getFjnrUrl() {
        return fjnrUrl;
    }

    public void setFjnrUrl(String fjnrUrl) {
        this.fjnrUrl = fjnrUrl;
    }
}
