package cn.gtmap.estateplat.model.server.core;

import cn.gtmap.estateplat.utils.Constants;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * .
 * <p/>
 * 项目新建的基本信息参数
 *
 * @author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
 * @version V1.0, 15-3-16
 */
public class Project extends BdcXm {

    /***************
     * zdd 20160128后的所有批量发证前台页面参数必须以BdcXmRel list对象方式传入
     * 统一处理逻辑 并且匹配的批量时可以确定权籍id与原项目ID对应关系  后续将project对象其他关系字段删除
     ***************/
    private List<BdcXmRel> bdcXmRelList;

    private String workFlowDefId;

    private String djId; //地籍信息主键


    private String yxmid; //原项目信息主键

    private String bdcdyh;

    private String zdzhh;//宗地宗海号

    private String bdclx;//不动产类型

    private String userId;
    private String taskid;

    private String gdslbh;
    //zdd 身份证读卡器
    private String qlrmc; //  zdd 新建项目填写权利人信息
    private String sfzmbh;//  zdd 新建项目读取身份证编号

    private String dcbIndex;//zdd 逻辑幢主键
    private List<String> dcbIndexs;

    private List<String> djIds;//zdd 当流程选择多个不动产单元时的 地籍参数
    private List<String> bdcdyhs;//zdd 批量选择多个不动产单元时的 不动产单元号
    private List<String> yxmids;//zdd 当流程选择多个原项目信息时 项目ID参数

    private String workflowProid; //zdd 创建工作流时 平台库存储记录的proid
    private String msg;//返回的信息
    private String tdids;

    private String gdproid;//zdd 所有过渡匹配项目  必须要有gdproid
    private String yqlid;//zdd 原权利ID
    private String ybdcdyid; //原不动产单元id
    private List<String> ybdcdyids;
    private String gdsyqid;//zdd 过渡 房屋所有权/土地使用权 主键
    private QllxVo qllxVo;//xhc 注销抵押时用

    private String djbid;//zdd 项目登记薄ID

    private String gdid;

	private String sfyc;

    public List<BdcXmRel> getBdcXmRelList() {
        return bdcXmRelList;
    }

    public void setBdcXmRelList(List<BdcXmRel> bdcXmRelList) {
        this.bdcXmRelList = bdcXmRelList;
    }

    public String getDjbid() {
        return djbid;
    }

    public void setDjbid(String djbid) {
        this.djbid = djbid;
    }

    public String getYqlid() {
        return yqlid;
    }

    public void setYqlid(String yqlid) {
        this.yqlid = yqlid;
    }

    public QllxVo getQllxVo() {
        return qllxVo;
    }

    public void setQllxVo(QllxVo qllxVo) {
        this.qllxVo = qllxVo;
    }

    public String getGdsyqid() {
        return gdsyqid;
    }

    public void setGdsyqid(String gdsyqid) {
        this.gdsyqid = gdsyqid;
    }

    public List<String> getYbdcdyids() {
        return ybdcdyids;
    }

    public void setYbdcdyids(List<String> ybdcdyids) {
        this.ybdcdyids = ybdcdyids;
    }

    public List<String> getBdcdyhs() {
        return bdcdyhs;
    }

    public void setBdcdyhs(List<String> bdcdyhs) {
        if (bdcdyhs != null && bdcdyhs.size() == 1) {
            List<String> tempbdcdyhs = new ArrayList<String>();
            String[] bdcdyhArray = bdcdyhs.get(0).split(Constants.SPLIT_STR);
            for (String bdcdyh : bdcdyhArray) {
                if (StringUtils.isNotBlank(bdcdyh))
                    tempbdcdyhs.add(bdcdyh);
            }
            if (tempbdcdyhs != null && tempbdcdyhs.size() > 0)
                bdcdyhs = tempbdcdyhs;
        }
        this.bdcdyhs = bdcdyhs;
    }

    public String getDcbIndex() {
        return dcbIndex;
    }

    public void setDcbIndex(String dcbIndex) {
        this.dcbIndex = dcbIndex;
    }

    public List<String> getDcbIndexs() {
        return dcbIndexs;
    }

    public void setDcbIndexs(List<String> dcbIndexs) {
        this.dcbIndexs = dcbIndexs;
    }

    public String getWorkflowProid() {
        return workflowProid;
    }

    public void setWorkflowProid(String workflowProid) {
        this.workflowProid = workflowProid;
    }

    public List<String> getYxmids() {
        return yxmids;
    }

    public void setYxmids(List<String> yxmids) {
        if (yxmids != null && yxmids.size() == 1) {
            List<String> tempYxmids = new ArrayList<String>();
            String[] djidArray = yxmids.get(0).split(Constants.SPLIT_STR);
            for (String xmid : djidArray) {
                if (StringUtils.isNotBlank(xmid))
                    tempYxmids.add(xmid);
            }
            if (tempYxmids != null && tempYxmids.size() > 0) {
                yxmids = tempYxmids;
            }

        }
        this.yxmids = yxmids;
    }

    public List<String> getDjIds() {
        return djIds;
    }

    public void setDjIds(List<String> djIds) {
        if (djIds != null && djIds.size() == 1) {
            List<String> tempDjids = new ArrayList<String>();
            String[] djidArray = djIds.get(0).split(Constants.SPLIT_STR);
            for (String djid : djidArray) {
                if (StringUtils.isNotBlank(djid))
                    tempDjids.add(djid);
            }
            if (tempDjids != null && tempDjids.size() > 0) {
                djIds = tempDjids;
            }

        }
        this.djIds = djIds;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getSfzmbh() {
        return sfzmbh;
    }

    public void setSfzmbh(String sfzmbh) {
        this.sfzmbh = sfzmbh;
    }

    public String getDjId() {
        return djId;
    }

    public void setDjId(String djId) {
        this.djId = djId;
    }

//    public String getTdid() {
//        return tdid;
//    }
//
//    public void setTdid(String tdid) {
//        this.tdid = tdid;
//    }
//
//    public String getFwid() {
//        return fwid;
//    }
//
//    public void setFwid(String fwid) {
//        this.fwid = fwid;
//    }

    public String getYxmid() {
        return yxmid;
    }

    public void setYxmid(String yxmid) {
        this.yxmid = yxmid;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getZdzhh() {
        if (StringUtils.isBlank(zdzhh) && StringUtils.isNotBlank(bdcdyh) && bdcdyh.length() > 19) {
            zdzhh = bdcdyh.substring(0, 19);
        } else if (StringUtils.isBlank(zdzhh) && bdcdyhs != null && bdcdyhs.size() > 0) {
            if (bdcdyhs.get(0).length() > 19)
                zdzhh = bdcdyhs.get(0).substring(0, 19);
        }
        return zdzhh;
    }

    public void setZdzhh(String zdzhh) {
        this.zdzhh = zdzhh;
    }

    public String getBdclx() {
        return bdclx;
    }

    public void setBdclx(String bdclx) {
        this.bdclx = bdclx;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getWorkFlowDefId() {
        return workFlowDefId;
    }

    public void setWorkFlowDefId(String workFlowDefId) {
        this.workFlowDefId = workFlowDefId;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

//    public String getLqid() {
//        return lqid;
//    }
//
//    public void setLqid(String lqid) {
//        this.lqid = lqid;
//    }
//
//    public String getCqid() {
//        return cqid;
//    }
//
//    public void setCqid(String cqid) {
//        this.cqid = cqid;
//    }


//    public String getDyid() {
//        return dyid;
//    }
//
//    public void setDyid(String dyid) {
//        this.dyid = dyid;
//    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

//    public String getYgid() {
//        return ygid;
//    }
//
//    public void setYgid(String ygid) {
//        this.ygid = ygid;
//    }
//
//    public String getCfid() {
//        return cfid;
//    }
//
//    public void setCfid(String cfid) {
//        this.cfid = cfid;
//    }
//
//    public String getYyid() {
//        return yyid;
//    }
//
//    public void setYyid(String yyid) {
//        this.yyid = yyid;
//    }

    public String getGdproid() {
        return gdproid;
    }

    public void setGdproid(String gdproid) {
        this.gdproid = gdproid;
    }

    public String getYbdcdyid() {
        return ybdcdyid;
    }

    public void setYbdcdyid(String ybdcdyid) {
        this.ybdcdyid = ybdcdyid;
    }

    public String getGdslbh() {
        return gdslbh;
    }

    public void setGdslbh(String gdslbh) {
        this.gdslbh = gdslbh;
    }

    public String getTdids() {
        return tdids;
    }

    public void setTdids(String tdids) {
        this.tdids = tdids;
    }

    public String getGdid() {
        return gdid;
    }

    public void setGdid(String gdid) {
        this.gdid = gdid;
    }

	public String getSfyc() {
		return sfyc;
	}

	public void setSfyc(String sfyc) {
		this.sfyc = sfyc;
	}
}
