/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.MasSmsService;
import com.gtis.config.AppConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.csapi.schema.sms.DeliveryInformation;
import org.csapi.schema.sms.DeliveryStatus;
import org.csapi.schema.sms.GetSmsDeliveryStatusRequest;
import org.csapi.schema.sms.GetSmsDeliveryStatusResponse;
import org.csapi.schema.sms.MessageFormat;
import org.csapi.schema.sms.SendMethodType;
import org.csapi.schema.sms.SendSmsRequest;
import org.csapi.schema.sms.SendSmsResponse;
import org.csapi.service.CmccMasWbs;
import org.csapi.service.CmccMasWbs_Service;
import org.csapi.service.PolicyException;
import org.csapi.service.ServiceException;

public class CmccSmsServiceForZjgImpl
implements MasSmsService {
    private CmccMasWbs cmccMasWbs;
    private String applicationID;

    public void setApplicationID(String applicationID) {
        this.applicationID = applicationID;
    }

    public void initMasSmsService() {
        if (StringUtils.isNotBlank((CharSequence)AppConfig.getProperty((String)"sms.url"))) {
            URL smsUrl = null;
            try {
                smsUrl = new URL(AppConfig.getProperty((String)"sms.url"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            CmccMasWbs_Service cmccMasWbs_service = new CmccMasWbs_Service(smsUrl);
            this.cmccMasWbs = cmccMasWbs_service.getCmccMasWbs();
        }
    }

    @Override
    public String sendSms(String phoneNum, String content) throws AppException {
        String requestIdentifier = "";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{phoneNum, content, this.applicationID}) && this.cmccMasWbs != null) {
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setApplicationID(this.applicationID);
            sendSmsRequest.setExtendCode(null);
            List destinationAddressesList = sendSmsRequest.getDestinationAddresses();
            destinationAddressesList.addAll(Arrays.asList(StringUtils.split((String)phoneNum, (String)",")));
            sendSmsRequest.setMessageFormat(MessageFormat.GB_18030);
            sendSmsRequest.setMessage(content);
            sendSmsRequest.setSendMethod(SendMethodType.LONG);
            sendSmsRequest.setDeliveryResultRequest(true);
            try {
                SendSmsResponse sendSmsResponse = this.cmccMasWbs.sendSms(sendSmsRequest);
                if (sendSmsResponse != null) {
                    requestIdentifier = sendSmsResponse.getRequestIdentifier();
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (PolicyException e) {
                e.printStackTrace();
            }
        }
        return requestIdentifier;
    }

    @Override
    public Boolean getStatus(String requestIdentifier) {
        Boolean flag;
        block4: {
            flag = false;
            GetSmsDeliveryStatusRequest getSmsDeliveryStatusRequest = new GetSmsDeliveryStatusRequest();
            getSmsDeliveryStatusRequest.setApplicationID(this.applicationID);
            getSmsDeliveryStatusRequest.setRequestIdentifier(requestIdentifier);
            try {
                List deliveryInformationList;
                GetSmsDeliveryStatusResponse getSmsDeliveryStatusResponse;
                if (this.cmccMasWbs == null || (getSmsDeliveryStatusResponse = this.cmccMasWbs.getSmsDeliveryStatus(getSmsDeliveryStatusRequest)) == null || !CollectionUtils.isNotEmpty((Collection)(deliveryInformationList = getSmsDeliveryStatusResponse.getItem()))) break block4;
                for (DeliveryInformation deliveryInformation : deliveryInformationList) {
                    if (!DeliveryStatus.DELIVERY_TO_TERMINAL.equals((Object)deliveryInformation.getDeliveryStatus())) continue;
                    flag = true;
                    break;
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (PolicyException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }
}

