package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.transition.QzFdcq1;

import java.util.List;

/**
 * 房地产权（项目内多幢房屋）信息接口
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 15-11-19
 */
public interface QzFdcq1Service {

    /**
     * 根据权利编号和表名（视图名）获取房地产权（项目内多幢房屋）信息
     *
     * @param qlbh
     * @param table
     * @return
     */
    public QzFdcq1 getQzFdcq1ByQlbh(String qlbh, String table);

    /**
     * 根据不动产单元编号和表名（视图名）获取房地产权（项目内多幢房屋）信息
     *
     * @param bdcdybh
     * @param table
     * @return
     */
    public List<QzFdcq1> getQzFdcq1ListByBdcdybh(String bdcdybh, String table);

    /**
     * 根据业务信息业务号和表名（视图名）获取房地产权（项目内多幢房屋）信息
     *
     * @param ywh
     * @param table
     * @return
     */
    public List<QzFdcq1> getQzFdcq1ListByYwh(String ywh, String table);
}
