package cn.gtmap.estateplat.service.examine;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.model.examine.BdcExamineParam;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/11/30
 * @description 不动产登记项目检查服务
 */
public interface BdcExamineService {
    /**
     * @param bdcExamineParamList 不动产登记项目检查对象，包括了proid等值
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/11/30
     * @description 检查一个或多个不动产登记项目的限制情况
     */
    Map<String, Object> performExamine(List<BdcExamineParam> bdcExamineParamList, String wiid) throws AppException;

    /**
     * @param ljzList 逻辑幢ID列表
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/11/30
     * @description 检查逻辑幢或者多个逻辑幢的限制情况
     */
    Map<String, Object> performExamineLjz(List<String> ljzList, String wiid) throws AppException;

}
