/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.insight.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;

public class HttpClientUtil {
    static final String charsetName = "UTF-8";

    public static String get(String url) throws ClientProtocolException, Exception {
        return HttpClientUtil.get(url, null);
    }

    public static String get(String url, String cookiePolicy) throws ClientProtocolException, Exception {
        System.out.println("HttpClientUtil \u53d1\u9001\u8bf7\u6c42,method: GET,TIME : " + System.currentTimeMillis() + ",URL : " + url);
        URL urlObj = new URL(url);
        URI uri = new URI(urlObj.getProtocol(), urlObj.getHost() + ":" + urlObj.getPort(), urlObj.getPath(), urlObj.getQuery(), null);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (cookiePolicy != null) {
            HttpClientParams.setCookiePolicy((HttpParams)httpClient.getParams(), (String)cookiePolicy);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        HttpGet httpGet = new HttpGet(uri);
        try {
            String response = (String)httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
            System.out.println("HttpClientUtil \u6536\u5230\u6570\u636e,method: GET,TIME : " + System.currentTimeMillis() + ",URL : " + url);
            String string = response;
            return string;
        }
        catch (ClientProtocolException e) {
            System.out.println("[ERROR] HttpClientUtil.get() error: url is [" + url + "]");
            System.out.println("HttpClientUtil \u8bf7\u6c42\u9519\u8bef,method: GET,URL : " + url);
            throw e;
        }
        catch (IOException e) {
            System.out.println("[ERROR] HttpClientUtil.get() error: url is [" + url + "]");
            System.out.println("HttpClientUtil \u8bf7\u6c42\u9519\u8bef,method: GET,URL : " + url);
            throw e;
        }
        finally {
            httpGet.abort();
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static String post(String url, Map<String, String> parameters) throws UnsupportedEncodingException, ClientProtocolException, IOException {
        return HttpClientUtil.post(url, parameters, null);
    }

    public static String post(String url, Map<String, String> parameters, String encoding) throws UnsupportedEncodingException, ClientProtocolException, IOException {
        return HttpClientUtil.post(url, parameters, encoding, null);
    }

    public static String post(String url, Map<String, String> etersparameters, String encoding, String cookiePolicy) throws UnsupportedEncodingException, ClientProtocolException, IOException {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<Map.Entry<String, String>> set = etersparameters.entrySet();
        for (Map.Entry<String, String> entry : set) {
            nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return HttpClientUtil.post(url, (HttpEntity)new UrlEncodedFormEntity(nvps, encoding), cookiePolicy);
    }

    public static String post(String url, String stringEntity) throws UnsupportedEncodingException, ClientProtocolException, IOException {
        StringEntity entity = new StringEntity(stringEntity);
        return HttpClientUtil.post(url, (HttpEntity)entity);
    }

    public static String post(String url, InputStream inputStream, long length) throws UnsupportedEncodingException, ClientProtocolException, IOException {
        InputStreamEntity entity = new InputStreamEntity(inputStream, length);
        return HttpClientUtil.post(url, (HttpEntity)entity);
    }

    public static String post(String url, HttpEntity parameter) throws UnsupportedEncodingException, ClientProtocolException, IOException {
        return HttpClientUtil.post(url, parameter, null);
    }

    public static String post(String url, HttpEntity parameter, String cookiePolicy) throws UnsupportedEncodingException, ClientProtocolException, IOException {
        System.out.println("HttpClientUtil \u53d1\u9001\u8bf7\u6c42,method: POST,TIME : " + System.currentTimeMillis() + ",URL : " + url);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (cookiePolicy != null) {
            HttpClientParams.setCookiePolicy((HttpParams)httpClient.getParams(), (String)cookiePolicy);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.setEntity(parameter);
            String response = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            System.out.println("HttpClientUtil \u6536\u5230\u6570\u636e,method: POST,TIME : " + System.currentTimeMillis() + ",URL : " + url);
            System.out.println("HttpClientUtil \u6536\u5230\u6570\u636e,method: POST,result: " + response.replace("\r", "").replace("\n", ""));
            String string = response;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("[ERROR] HttpClientUtil.post() error: url is [" + url + "]");
            System.out.println("HttpClientUtil \u8bf7\u6c42\u9519\u8bef,method: POST,URL : " + url);
            throw e;
        }
        catch (ClientProtocolException e) {
            System.out.println("[ERROR] HttpClientUtil.post() error: url is [" + url + "]");
            System.out.println("HttpClientUtil \u8bf7\u6c42\u9519\u8bef,method: POST,URL : " + url);
            throw e;
        }
        catch (IOException e) {
            System.out.println("[ERROR] HttpClientUtil.post() error: url is [" + url + "]");
            System.out.println("HttpClientUtil \u8bf7\u6c42\u9519\u8bef,method: POST,URL : " + url);
            throw e;
        }
        finally {
            httpPost.abort();
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static String doPost(String url, String value) throws MalformedURLException, IOException {
        HttpURLConnection urlconn = null;
        BufferedReader rd = null;
        StringBuffer sb = new StringBuffer();
        try {
            urlconn = (HttpURLConnection)new URL(url).openConnection();
            urlconn.getRequestProperties();
            urlconn.setRequestProperty("content-type", "application/json; charset=UTF-8");
            urlconn.setRequestMethod("POST");
            urlconn.setConnectTimeout(10000);
            urlconn.setReadTimeout(10000);
            urlconn.setDoInput(true);
            urlconn.setDoOutput(true);
            urlconn.getOutputStream().write(value.getBytes(charsetName));
            urlconn.getOutputStream().close();
            rd = new BufferedReader(new InputStreamReader(urlconn.getInputStream(), charsetName));
            String temp = null;
            temp = rd.readLine();
            while (temp != null) {
                sb.append(temp);
                temp = rd.readLine();
            }
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (rd != null) {
                    rd.close();
                }
            }
            catch (Exception fx) {
                System.out.println(fx.getMessage());
            }
            try {
                if (urlconn != null) {
                    urlconn.disconnect();
                }
            }
            catch (Exception fx) {
                System.out.println(fx.getMessage());
            }
        }
        return sb.toString();
    }
}

