/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.insight.util;

import com.dh.DpsdkCore.Area_Detect_Info_t;
import com.dh.DpsdkCore.Device_Info_Ex_t;
import com.dh.DpsdkCore.Get_Channel_Info_Ex_t;
import com.dh.DpsdkCore.Get_Dep_Count_Info_t;
import com.dh.DpsdkCore.Get_Dep_Info_t;
import com.dh.DpsdkCore.IDpsdkCore;
import com.dh.DpsdkCore.Login_Info_t;
import com.dh.DpsdkCore.Return_Value_Info_t;
import com.dh.DpsdkCore.Traffic_Alarm_Info_t;
import com.dh.DpsdkCore.fDPSDKDevStatusCallback;
import com.dh.DpsdkCore.fDPSDKGeneralJsonTransportCallback;
import com.dh.DpsdkCore.fDPSDKGetAreaSpeedDetectCallback;
import com.dh.DpsdkCore.fDPSDKGetBayCarInfoCallbackEx;
import com.dh.DpsdkCore.fDPSDKNVRChnlStatusCallback;
import com.dh.DpsdkCore.fDPSDKTrafficAlarmCallback;
import java.io.IOException;

public class DpSDKUtil {
    public static int m_nDLLHandle = -1;
    public static String StrCarNum;
    public static Return_Value_Info_t nGroupLen;
    public static fDPSDKDevStatusCallback fDeviceStatus;
    public static fDPSDKNVRChnlStatusCallback fNVRChnlStatus;
    public static fDPSDKGeneralJsonTransportCallback fGeneralJson;
    public static fDPSDKGetBayCarInfoCallbackEx fBayCarInfo;
    public static fDPSDKTrafficAlarmCallback fTrafficAlarmCallback;
    public static fDPSDKGetAreaSpeedDetectCallback fGetAreaSpeedDetectCallback;

    public static void OnCreate() {
        int nRet = -1;
        Return_Value_Info_t res = new Return_Value_Info_t();
        nRet = IDpsdkCore.DPSDK_Create(1, res);
        m_nDLLHandle = res.nReturnValue;
        String dpsdklog = "D:\\temp\\dpsdkjavalog";
        nRet = IDpsdkCore.DPSDK_SetLog(m_nDLLHandle, dpsdklog.getBytes());
        String dumpfile = "D:\\temp\\dpsdkjavadump";
        nRet = IDpsdkCore.DPSDK_StartMonitor(m_nDLLHandle, dumpfile.getBytes());
        if (m_nDLLHandle > 0) {
            nRet = IDpsdkCore.DPSDK_SetDPSDKDeviceStatusCallback(m_nDLLHandle, fDeviceStatus);
            nRet = IDpsdkCore.DPSDK_SetDPSDKNVRChnlStatusCallback(m_nDLLHandle, fNVRChnlStatus);
            nRet = IDpsdkCore.DPSDK_SetGeneralJsonTransportCallback(m_nDLLHandle, fGeneralJson);
            nRet = IDpsdkCore.DPSDK_SetDPSDKGetBayCarInfoCallbackEx(m_nDLLHandle, fBayCarInfo);
            nRet = IDpsdkCore.DPSDK_SetDPSDKTrafficAlarmCallback(m_nDLLHandle, fTrafficAlarmCallback);
            nRet = IDpsdkCore.DPSDK_SetDPSDKGetAreaSpeedDetectCallback(m_nDLLHandle, fGetAreaSpeedDetectCallback);
        }
        System.out.print("\u521b\u5efaDPSDK, \u8fd4\u56de m_nDLLHandle = ");
        System.out.println(m_nDLLHandle);
    }

    public static void OnLogin(String m_strIp, int m_nPort, String m_strUser, String m_strPassword) {
        Login_Info_t loginInfo = new Login_Info_t();
        loginInfo.szIp = m_strIp.getBytes();
        loginInfo.nPort = m_nPort;
        loginInfo.szUsername = m_strUser.getBytes();
        loginInfo.szPassword = m_strPassword.getBytes();
        loginInfo.nProtocol = 2;
        loginInfo.iType = 1;
        int nRet = IDpsdkCore.DPSDK_Login(m_nDLLHandle, loginInfo, 10000);
        if (nRet == 0) {
            System.out.printf("\u767b\u5f55\u6210\u529f\uff0cnRet = %d", nRet);
        } else {
            System.out.printf("\u767b\u5f55\u5931\u8d25\uff0cnRet = %d", nRet);
        }
        System.out.println();
    }

    public static void LoadAllGroup() {
        int nRet = IDpsdkCore.DPSDK_LoadDGroupInfo(m_nDLLHandle, nGroupLen, 180000);
        if (nRet == 0) {
            System.out.printf("\u52a0\u8f7d\u6240\u6709\u7ec4\u7ec7\u6811\u6210\u529f\uff0cnRet = %d\uff0c nDepCount = %d", nRet, DpSDKUtil.nGroupLen.nReturnValue);
        } else {
            System.out.printf("\u52a0\u8f7d\u6240\u6709\u7ec4\u7ec7\u6811\u5931\u8d25\uff0cnRet = %d", nRet);
        }
        System.out.println();
    }

    public static Get_Dep_Info_t GetGroupStr(String deviceCode) {
        Get_Dep_Info_t getInfo = null;
        byte[] coding = deviceCode.getBytes();
        byte[] szGroupBuf = new byte[DpSDKUtil.nGroupLen.nReturnValue];
        Get_Dep_Count_Info_t getCount = new Get_Dep_Count_Info_t();
        getCount.szCoding = coding;
        int nRetCount = IDpsdkCore.DPSDK_GetDGroupCount(m_nDLLHandle, getCount);
        getInfo = new Get_Dep_Info_t(getCount.nDepCount, getCount.nDeviceCount);
        getInfo.szCoding = coding;
        int nRet = IDpsdkCore.DPSDK_GetDGroupInfo(m_nDLLHandle, getInfo);
        if (nRet == 0) {
            String GroupBuf = "";
            try {
                GroupBuf = new String(szGroupBuf, "UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.printf("\u83b7\u53d6\u6240\u6709\u7ec4\u7ec7\u6811\u4e32\u5931\u8d25\uff0cnRet = %d", nRet);
        }
        return getInfo;
    }

    public static Get_Channel_Info_Ex_t GetChannelStr(byte[] deviceId, int channelCount) {
        byte[] szGroupBuf = new byte[DpSDKUtil.nGroupLen.nReturnValue];
        Get_Channel_Info_Ex_t getChannelInfoEx = new Get_Channel_Info_Ex_t(channelCount);
        getChannelInfoEx.szDeviceId = deviceId;
        int nRetCount = IDpsdkCore.DPSDK_GetChannelInfoEx(m_nDLLHandle, getChannelInfoEx);
        if (nRetCount == 0) {
            String GroupBuf = "";
            try {
                GroupBuf = new String(szGroupBuf, "UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.printf("\u83b7\u53d6\u6240\u6709\u901a\u9053\u6811\u4e32\u6210\u529f\uff0cnRet = %d\uff0c szGroupBuf = [%s]", nRetCount, GroupBuf);
        } else {
            System.out.printf("\u83b7\u53d6\u6240\u6709\u901a\u9053\u6811\u4e32\u5931\u8d25\uff0cnRet = %d", nRetCount);
        }
        return getChannelInfoEx;
    }

    static {
        nGroupLen = new Return_Value_Info_t();
        fDeviceStatus = new fDPSDKDevStatusCallback(){

            @Override
            public void invoke(int nPDLLHandle, byte[] szDeviceId, int nStatus) {
                String status = "\u79bb\u7ebf";
                if (nStatus == 1) {
                    status = "\u5728\u7ebf";
                    Device_Info_Ex_t deviceInfo = new Device_Info_Ex_t();
                    int nRet = IDpsdkCore.DPSDK_GetDeviceInfoExById(m_nDLLHandle, szDeviceId, deviceInfo);
                    if ((deviceInfo.nDevType == 6 || deviceInfo.nDevType == 10 || deviceInfo.nDevType == 14 || deviceInfo.nDevType == 302) && (nRet = IDpsdkCore.DPSDK_QueryNVRChnlStatus(m_nDLLHandle, szDeviceId, 10000)) != 0) {
                        System.out.printf("\u67e5\u8be2NVR\u901a\u9053\u72b6\u6001\u5931\u8d25\uff0cdeviceID = %s, nRet = %d", new String(szDeviceId), nRet);
                    }
                }
            }
        };
        fNVRChnlStatus = new fDPSDKNVRChnlStatusCallback(){

            @Override
            public void invoke(int nPDLLHandle, byte[] szCameraId, int nStatus) {
                String status = "\u79bb\u7ebf";
                if (nStatus == 1) {
                    status = "\u5728\u7ebf";
                }
            }
        };
        fGeneralJson = new fDPSDKGeneralJsonTransportCallback(){

            @Override
            public void invoke(int nPDLLHandle, byte[] szJson) {
                System.out.printf("General Json Return, ReturnJson = %s", new String(szJson));
                System.out.println();
            }
        };
        fBayCarInfo = new fDPSDKGetBayCarInfoCallbackEx(){

            @Override
            public void invoke(int nPDLLHandle, byte[] szDeviceId, int nDeviceIdLen, int nDevChnId, byte[] szChannelId, int nChannelIdLen, byte[] szDeviceName, int nDeviceNameLen, byte[] szDeviceChnName, int nChanNameLen, byte[] szCarNum, int nCarNumLen, int nCarNumType, int nCarNumColor, int nCarSpeed, int nCarType, int nCarColor, int nCarLen, int nCarDirect, int nWayId, long lCaptureTime, long lPicGroupStoreID, int nIsNeedStore, int nIsStoraged, byte[] szCaptureOrg, int nCaptureOrgLen, byte[] szOptOrg, int nOptOrgLen, byte[] szOptUser, int nOptUserLen, byte[] szOptNote, int nOptNoteLen, byte[] szImg0Path, int nImg0PathLen, byte[] szImg1Path, int nImg1PathLen, byte[] szImg2Path, int nImg2PathLen, byte[] szImg3Path, int nImg3PathLen, byte[] szImg4Path, int nImg4PathLen, byte[] szImg5Path, int nImg5PathLen, byte[] szImgPlatePath, int nImgPlatePathLen, int icarLog, int iPlateLeft, int iPlateRight, int iPlateTop, int iPlateBottom) {
                try {
                    StrCarNum = new String(szCarNum, "UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.printf("Bay Car Info Report, DeviceId=%s, szChannelId=%s, szDeviceChnName=%s, szCarNum=%s, szImg0Path=%s", new String(szDeviceId), new String(szChannelId), new String(szDeviceChnName), StrCarNum, new String(szImg0Path));
                System.out.println();
            }
        };
        fTrafficAlarmCallback = new fDPSDKTrafficAlarmCallback(){

            @Override
            public void invoke(int nPDLLHandle, Traffic_Alarm_Info_t trafficAlarmInfo) {
                try {
                    StrCarNum = new String(trafficAlarmInfo.szCarNum, "UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.printf("TrafficAlarm Car Info Report, DeviceId=%s, szChannelId=%s, szDeviceChnName=%s, szCarNum=%s, szImg0Path=%s", new String(trafficAlarmInfo.szDeviceId).trim(), new String(trafficAlarmInfo.szCameraId).trim(), new String(trafficAlarmInfo.szDeviceName).trim(), StrCarNum.trim(), new String(trafficAlarmInfo.szPicUrl0).trim());
                System.out.println();
            }
        };
        fGetAreaSpeedDetectCallback = new fDPSDKGetAreaSpeedDetectCallback(){

            @Override
            public void invoke(int nPDLLHandle, Area_Detect_Info_t areaSpeedDetectInfo) {
                try {
                    StrCarNum = new String(areaSpeedDetectInfo.szCarNum, "UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.printf("AreaSpeedDetectInfo Report, szCarNum=%s, szPicName0=%s", StrCarNum.trim(), new String(areaSpeedDetectInfo.szPicName0).trim());
                System.out.println();
            }
        };
    }
}

