/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.insight.sdk.cmcc;

import cn.gtmap.insight.util.CommonUtil;
import com.allcam.acs.core.AcsConfig;
import com.allcam.acs.core.AcsService;
import com.allcam.common.base.BaseRequest;
import com.allcam.common.base.BaseResponse;
import com.allcam.common.entity.CameraInfo;
import com.allcam.common.model.PageInfo;
import com.allcam.common.service.device.model.DeviceSearchInfo;
import com.allcam.common.service.device.request.DeviceListRequest;
import com.allcam.common.service.device.request.DeviceListResponse;
import com.allcam.common.service.live.request.LiveBrowseRequest;
import com.allcam.common.service.live.request.LiveBrowseResponse;
import com.allcam.common.service.ptz.request.PtzControlRequest;
import com.allcam.common.service.record.model.RecordSearch;
import com.allcam.common.service.record.request.RecordListRequest;
import com.allcam.common.service.record.request.RecordListResponse;
import com.allcam.common.service.record.request.RecordUrlRequest;
import com.allcam.common.service.record.request.RecordUrlResponse;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmccSDK {
    protected static final Logger logger = LoggerFactory.getLogger(CmccSDK.class);
    private static CmccSDK cmccSDK = null;
    private static AcsService service = null;

    private CmccSDK() {
    }

    public static CmccSDK getInstance() {
        if (cmccSDK == null) {
            return new CmccSDK();
        }
        return cmccSDK;
    }

    public static void init(String ip, int port, String userName, String passWord) {
        AcsConfig config = new AcsConfig.Builder().host(ip).port(port).username(userName).password(passWord).httpTimeout(60).build();
        service = AcsService.getInstance();
        service.init(config);
    }

    public static DeviceListResponse getDeviceList(String clientId, Integer type, Integer countOnOffLine) {
        try {
            DeviceListRequest request = new DeviceListRequest();
            DeviceSearchInfo searchInfo = new DeviceSearchInfo();
            if (StringUtils.isNotBlank((CharSequence)clientId)) {
                searchInfo.setClientId(clientId);
            }
            if (type != null) {
                searchInfo.setType(type.intValue());
            }
            if (countOnOffLine != null) {
                searchInfo.setCountOnOffLine(countOnOffLine.intValue());
            }
            request.setSearchInfo(searchInfo);
            return (DeviceListResponse)service.request((BaseRequest)request);
        }
        catch (Exception e) {
            logger.error("getDeviceList", (Throwable)e);
            return null;
        }
    }

    public static BaseResponse ptzControl(String deviceId, String direction, Integer length, Integer speed) {
        try {
            PtzControlRequest request = new PtzControlRequest();
            request.setCameraId(deviceId);
            request.setOpCode(direction);
            String lengthStr = "2";
            if (length != null && length >= 1 && length <= 10) {
                lengthStr = String.valueOf(length);
            }
            request.setParam1(lengthStr);
            String speedStr = "5";
            if (speed != null && speed >= 1 && speed <= 10) {
                speedStr = String.valueOf(speed);
            }
            request.setParam2(speedStr);
            return service.request((BaseRequest)request);
        }
        catch (Exception e) {
            logger.error("getDeviceList", (Throwable)e);
            return null;
        }
    }

    public static LiveBrowseResponse getLiveUrl(String deviceId, Integer streamType, Integer urlType, Integer agentType) {
        try {
            LiveBrowseRequest request = new LiveBrowseRequest();
            if (StringUtils.isNotBlank((CharSequence)deviceId)) {
                request.setCameraId(deviceId);
            }
            if (streamType != null) {
                request.setStreamType(streamType.intValue());
            }
            if (urlType != null) {
                request.setUrlType(urlType.intValue());
            }
            if (agentType != null) {
                request.setAgentType(agentType.intValue());
            }
            return (LiveBrowseResponse)service.request((BaseRequest)request);
        }
        catch (Exception e) {
            logger.error("getLiveUrl", (Throwable)e);
            return null;
        }
    }

    public static RecordUrlResponse getRecordUrl(String deviceId, Integer streamType, Integer urlType, Integer agentType) {
        try {
            RecordUrlRequest request = new RecordUrlRequest();
            if (StringUtils.isNotBlank((CharSequence)deviceId)) {
                request.setCameraId(deviceId);
            }
            if (streamType != null) {
                request.setStreamType(streamType.intValue());
            }
            if (urlType != null) {
                request.setUrlType(urlType.intValue());
            }
            if (agentType != null) {
                request.setAgentType(agentType.intValue());
            }
            return (RecordUrlResponse)service.request((BaseRequest)request);
        }
        catch (Exception e) {
            logger.error("getRecordUrl", (Throwable)e);
            return null;
        }
    }

    public static RecordListResponse getRecordList(String deviceId, Date beginTime, Date endTime) {
        try {
            RecordListRequest request = new RecordListRequest();
            ArrayList<CameraInfo> cameraList = new ArrayList<CameraInfo>();
            CameraInfo cameraInfo = new CameraInfo();
            cameraInfo.setCameraId(deviceId);
            cameraList.add(cameraInfo);
            request.setCameraList(cameraList);
            PageInfo pageInfo = new PageInfo();
            pageInfo.setPageNum(1);
            request.setPageInfo(pageInfo);
            RecordSearch recordSearch = new RecordSearch();
            recordSearch.setBeginTime(CommonUtil.date2string(beginTime, "yyyy-MM-dd HH:mm:ss"));
            recordSearch.setEndTime(CommonUtil.date2string(endTime, "yyyy-MM-dd HH:mm:ss"));
            request.setSearchInfo(recordSearch);
            return (RecordListResponse)service.request((BaseRequest)request);
        }
        catch (Exception e) {
            logger.error("getRecordList", (Throwable)e);
            return null;
        }
    }
}

