/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.theme.DefaultTheme;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geoserver.wms.web.publish.LegendGraphicAjaxUpdater;
import org.geoserver.wms.web.publish.StyleChoiceRenderer;
import org.geoserver.wms.web.publish.StyleNameRenderer;
import org.geoserver.wms.web.publish.StylesModel;

public class WMSLayerConfig
extends PublishedConfigurationPanel<LayerInfo> {
    private static final long serialVersionUID = -2895136226805357532L;

    public WMSLayerConfig(String id, IModel<LayerInfo> layerModel) {
        super(id, layerModel);
        this.add(new Component[]{new CheckBox("queryableEnabled", (IModel)new PropertyModel(layerModel, "queryable"))});
        this.add(new Component[]{new CheckBox("opaqueEnabled", (IModel)new PropertyModel(layerModel, "opaque"))});
        WebMarkupContainer styleContainer = new WebMarkupContainer("styles");
        this.add(new Component[]{styleContainer});
        ResourceInfo resource = ((LayerInfo)layerModel.getObject()).getResource();
        styleContainer.setVisible(resource instanceof CoverageInfo || resource instanceof FeatureTypeInfo);
        StylesModel styles = new StylesModel();
        PropertyModel defaultStyleModel = new PropertyModel(layerModel, "defaultStyle");
        Select2DropDownChoice defaultStyle = new Select2DropDownChoice("defaultStyle", (IModel)defaultStyleModel, (IModel)styles, (IChoiceRenderer)new StyleChoiceRenderer());
        defaultStyle.setRequired(true);
        styleContainer.add(new Component[]{defaultStyle});
        NonCachingImage defStyleImg = new NonCachingImage("defaultStyleLegendGraphic");
        defStyleImg.setOutputMarkupId(true);
        styleContainer.add(new Component[]{defStyleImg});
        String wmsURL = RequestCycle.get().getUrlRenderer().renderContextRelativeUrl("wms") + "?";
        final LegendGraphicAjaxUpdater defaultStyleUpdater = new LegendGraphicAjaxUpdater(wmsURL, (Image)defStyleImg, (IModel<StyleInfo>)defaultStyleModel);
        defaultStyle.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = -4098934889965471248L;

            protected void onUpdate(AjaxRequestTarget target) {
                defaultStyleUpdater.updateStyleImage(target);
            }
        }});
        LiveCollectionModel stylesModel = LiveCollectionModel.set((IModel)new PropertyModel(layerModel, "styles"));
        Palette<StyleInfo> extraStyles = new Palette<StyleInfo>("extraStyles", (IModel)stylesModel, (IModel)styles, (IChoiceRenderer)new StyleNameRenderer(), 10, false){
            private static final long serialVersionUID = -3494299396410932090L;

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.availableHeader"));
            }
        };
        extraStyles.add(new Behavior[]{new DefaultTheme()});
        styleContainer.add(new Component[]{extraStyles});
        TextField renderingBuffer = new TextField("renderingBuffer", (IModel)new MapModel((IModel)new PropertyModel(layerModel, "metadata"), "buffer"), Integer.class);
        renderingBuffer.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        styleContainer.add(new Component[]{renderingBuffer});
        this.add(new Component[]{new TextField("wmsPath", (IModel)new PropertyModel(layerModel, "path"))});
        List<LayerInfo.WMSInterpolation> interpolChoices = Arrays.asList(LayerInfo.WMSInterpolation.values());
        PropertyModel defaultInterpolModel = new PropertyModel(layerModel, "defaultWMSInterpolationMethod");
        DropDownChoice interpolDropDown = new DropDownChoice("defaultInterpolationMethod", (IModel)defaultInterpolModel, interpolChoices, (IChoiceRenderer)new InterpolationRenderer((Component)this));
        interpolDropDown.setNullValid(true);
        this.add(new Component[]{interpolDropDown});
    }

    private class InterpolationRenderer
    extends ChoiceRenderer<LayerInfo.WMSInterpolation> {
        private static final long serialVersionUID = 4230274692882585457L;
        private Component parent;

        public InterpolationRenderer(Component parent) {
            this.parent = parent;
        }

        public Object getDisplayValue(LayerInfo.WMSInterpolation interpolationMethod) {
            return new StringResourceModel(interpolationMethod.name(), this.parent).getString();
        }

        public String getIdValue(LayerInfo.WMSInterpolation object, int index) {
            return object.name();
        }
    }
}

