/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;

public class ExternalGraphicPanel
extends Panel {
    private static final long serialVersionUID = 5098470683723890874L;
    private TextField<String> onlineResource;
    private TextField<String> format;
    private TextField<Integer> width;
    private TextField<Integer> height;
    private WebMarkupContainer table;
    private GeoServerAjaxFormLink autoFill;
    private Form<StyleInfo> showhideForm;
    private AjaxButton show;
    private AjaxButton hide;
    private Model<String> showhideStyleModel = new Model((Serializable)((Object)""));

    public ExternalGraphicPanel(String id, final CompoundPropertyModel<StyleInfo> styleModel, Form<?> styleForm) {
        super(id, styleModel);
        WebMarkupContainer container = new WebMarkupContainer("externalGraphicContainer");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.table = new WebMarkupContainer("list");
        this.table.setOutputMarkupId(true);
        IModel bind = styleModel.bind("legend.onlineResource");
        this.onlineResource = new TextField("onlineResource", bind);
        this.onlineResource.add((IValidator)new IValidator<String>(){
            final List<String> EXTENSIONS = Arrays.asList("png", "gif", "jpeg", "jpg");

            public void validate(IValidatable<String> input) {
                int last;
                String value = (String)input.getValue();
                int n = last = value == null ? -1 : value.lastIndexOf(46);
                if (last == -1 || !this.EXTENSIONS.contains(value.substring(last + 1).toLowerCase())) {
                    ValidationError error = new ValidationError();
                    error.setMessage("Not an image");
                    error.addKey("nonImage");
                    input.error((IValidationError)error);
                    return;
                }
                URI uri = null;
                try {
                    uri = new URI(value);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                if (uri != null && uri.isAbsolute()) {
                    try {
                        URL url;
                        URLConnection conn;
                        String baseUrl = ExternalGraphicPanel.this.baseURL(ExternalGraphicPanel.this.onlineResource.getForm());
                        if (!value.startsWith(baseUrl)) {
                            ExternalGraphicPanel.this.onlineResource.warn((Serializable)((Object)("Recommend use of styles directory at " + baseUrl)));
                        }
                        if ("text/html".equals((conn = (url = uri.toURL()).openConnection()).getContentType())) {
                            ValidationError error = new ValidationError();
                            error.setMessage("Unable to access image");
                            error.addKey("imageUnavailable");
                            input.error((IValidationError)error);
                            return;
                        }
                    }
                    catch (MalformedURLException e) {
                        ValidationError error = new ValidationError();
                        error.setMessage("Unable to access image");
                        error.addKey("imageUnavailable");
                        input.error((IValidationError)error);
                    }
                    catch (IOException e) {
                        ValidationError error = new ValidationError();
                        error.setMessage("Unable to access image");
                        error.addKey("imageUnavailable");
                        input.error((IValidationError)error);
                    }
                    return;
                }
                GeoServerResourceLoader resources = GeoServerApplication.get().getResourceLoader();
                try {
                    File styles = resources.find("styles");
                    String[] path = value.split(Pattern.quote(File.separator));
                    WorkspaceInfo wsInfo = ((StyleInfo)styleModel.getObject()).getWorkspace();
                    File test = null;
                    if (wsInfo != null) {
                        String wsName = wsInfo.getName();
                        ArrayList<String> list = new ArrayList<String>();
                        list.addAll(Arrays.asList("workspaces", wsName, "styles"));
                        list.addAll(Arrays.asList(path));
                        test = resources.find(list.toArray(new String[list.size()]));
                    }
                    if (test == null) {
                        test = resources.find(styles, path);
                    }
                    if (test == null) {
                        ValidationError error = new ValidationError();
                        error.setMessage("File not found in styles directory");
                        error.addKey("imageNotFound");
                        input.error((IValidationError)error);
                    }
                }
                catch (IOException e) {
                    ValidationError error = new ValidationError();
                    error.setMessage("File not found in styles directory");
                    error.addKey("imageNotFound");
                    input.error((IValidationError)error);
                }
            }
        });
        this.onlineResource.setOutputMarkupId(true);
        this.table.add(new Component[]{this.onlineResource});
        this.autoFill = new GeoServerAjaxFormLink("autoFill", styleForm){

            public void onClick(AjaxRequestTarget target, Form<?> form) {
                URLConnection conn = ExternalGraphicPanel.this.getExternalGraphic(target, form);
                if (conn == null) {
                    ValidationError error = new ValidationError();
                    error.setMessage("Unable to access image");
                    error.addKey("imageUnavailable");
                    ExternalGraphicPanel.this.onlineResource.error((IValidationError)error);
                } else {
                    ExternalGraphicPanel.this.format.setModelValue(new String[]{conn.getContentType()});
                    try {
                        BufferedImage image = ImageIO.read(conn.getInputStream());
                        ExternalGraphicPanel.this.width.setModelValue(new String[]{"" + image.getWidth()});
                        ExternalGraphicPanel.this.height.setModelValue(new String[]{"" + image.getHeight()});
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    target.add(new Component[]{ExternalGraphicPanel.this.format});
                    target.add(new Component[]{ExternalGraphicPanel.this.width});
                    target.add(new Component[]{ExternalGraphicPanel.this.height});
                }
            }
        };
        this.table.add(new Component[]{this.autoFill});
        this.format = new TextField("format", styleModel.bind("legend.format"));
        this.format.setOutputMarkupId(true);
        this.table.add(new Component[]{this.format});
        this.width = new TextField("width", styleModel.bind("legend.width"), Integer.class);
        this.width.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.width.setRequired(true);
        this.width.setOutputMarkupId(true);
        this.table.add(new Component[]{this.width});
        this.height = new TextField("height", styleModel.bind("legend.height"), Integer.class);
        this.height.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.height.setRequired(true);
        this.height.setOutputMarkupId(true);
        this.table.add(new Component[]{this.height});
        this.table.add(new Behavior[]{new AttributeModifier("style", this.showhideStyleModel)});
        container.add(new Component[]{this.table});
        this.showhideForm = new Form<StyleInfo>("showhide"){

            protected void onSubmit() {
                super.onSubmit();
            }
        };
        this.showhideForm.setMarkupId("showhideForm");
        container.add(new Component[]{this.showhideForm});
        this.showhideForm.setMultiPart(true);
        this.show = new AjaxButton("show"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ExternalGraphicPanel.this.updateVisibility(true);
                target.add(new Component[]{ExternalGraphicPanel.this});
            }
        };
        container.add(new Component[]{this.show});
        this.showhideForm.add(new Component[]{this.show});
        this.hide = new AjaxButton("hide"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ExternalGraphicPanel.this.onlineResource.setModelObject((Object)"");
                ExternalGraphicPanel.this.onlineResource.clearInput();
                ExternalGraphicPanel.this.format.setModelObject((Object)"");
                ExternalGraphicPanel.this.format.clearInput();
                ExternalGraphicPanel.this.width.setModelObject((Object)0);
                ExternalGraphicPanel.this.width.clearInput();
                ExternalGraphicPanel.this.height.setModelObject((Object)0);
                ExternalGraphicPanel.this.height.clearInput();
                ExternalGraphicPanel.this.updateVisibility(false);
                target.add(new Component[]{ExternalGraphicPanel.this});
            }
        };
        container.add(new Component[]{this.hide});
        this.showhideForm.add(new Component[]{this.hide});
        LegendInfo legend = ((StyleInfo)styleModel.getObject()).getLegend();
        boolean visible = legend != null && legend.getOnlineResource() != null && !legend.getOnlineResource().isEmpty();
        this.updateVisibility(visible);
    }

    protected String baseURL(Form<?> form) {
        GeoServer gs;
        HttpServletRequest httpServletRequest = (HttpServletRequest)form.getRequest().getContainerRequest();
        String baseUrl = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL");
        if (StringUtils.isEmpty((CharSequence)baseUrl) && StringUtils.isEmpty((CharSequence)(baseUrl = (gs = GeoServerApplication.get().getGeoServer()).getGlobal().getSettings().getProxyBaseUrl()))) {
            return ResponseUtils.baseURL((HttpServletRequest)httpServletRequest);
        }
        return baseUrl;
    }

    protected URLConnection getExternalGraphic(AjaxRequestTarget target, Form<?> form) {
        this.onlineResource.processInput();
        if (this.onlineResource.getModelObject() != null) {
            URL url = null;
            try {
                URLConnection conn;
                String baseUrl = this.baseURL(form);
                String external = ((String)this.onlineResource.getModelObject()).toString();
                URI uri = new URI(external);
                if (uri.isAbsolute()) {
                    url = uri.toURL();
                    if (!external.startsWith(baseUrl)) {
                        form.warn((Serializable)((Object)("Recommend use of styles directory at " + baseUrl)));
                    }
                } else {
                    WorkspaceInfo wsInfo = ((StyleInfo)this.getDefaultModelObject()).getWorkspace();
                    url = wsInfo != null ? new URL(ResponseUtils.appendPath((String[])new String[]{baseUrl, "styles", wsInfo.getName(), external})) : new URL(ResponseUtils.appendPath((String[])new String[]{baseUrl, "styles", external}));
                }
                if ("text/html".equals((conn = url.openConnection()).getContentType())) {
                    form.error((Serializable)((Object)"Unable to access url"));
                    return null;
                }
                return conn;
            }
            catch (FileNotFoundException notFound) {
                form.error((Serializable)((Object)("Unable to access " + url)));
            }
            catch (Exception e) {
                e.printStackTrace();
                form.error((Serializable)((Object)("Recommend use of styles directory at " + e)));
            }
        }
        return null;
    }

    protected String getOnlineResource() {
        return this.onlineResource.getInput();
    }

    private void updateVisibility(boolean b) {
        if (b) {
            this.showhideStyleModel.setObject((Serializable)((Object)""));
        } else {
            this.showhideStyleModel.setObject((Serializable)((Object)"display:none"));
        }
        this.autoFill.setVisible(b);
        this.hide.setVisible(b);
        this.show.setVisible(!b);
    }
}

