/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.PanelCachingTab;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.FileSystemResourceReference;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.SLDNamedLayerValidator;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wms.web.data.LayerAssociationPanel;
import org.geoserver.wms.web.data.LayerAttributePanel;
import org.geoserver.wms.web.data.OpenLayersPreviewPanel;
import org.geoserver.wms.web.data.StyleAdminPanel;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geoserver.wms.web.data.StyleEditTabPanel;
import org.geoserver.wms.web.data.StyleEditTabPanelInfo;
import org.geoserver.wms.web.data.StylePage;
import org.geotools.styling.StyledLayerDescriptor;
import org.xml.sax.SAXParseException;

public abstract class AbstractStylePage
extends GeoServerSecuredPage {
    static final Pattern HEX_COLOR = Pattern.compile("^#(?:[0-9a-fA-F]{3}){1,2}$");
    protected Form<StyleInfo> styleForm;
    protected AjaxTabbedPanel<ITab> tabbedPanel;
    protected CodeMirrorEditor editor;
    protected ModalWindow popup;
    protected CompoundPropertyModel<StyleInfo> styleModel;
    protected IModel<LayerInfo> layerModel;
    String rawStyle;

    public AbstractStylePage() {
    }

    public AbstractStylePage(StyleInfo style) {
        this.recoverCssStyle(style);
        this.initPreviewLayer(style);
        this.initUI(style);
    }

    protected void initPreviewLayer(StyleInfo style) {
        DataStoreInfo defaultStore;
        List layers;
        Catalog catalog = this.getCatalog();
        if (style != null && (layers = catalog.getLayers(style)).size() > 0) {
            this.layerModel = new Model((Serializable)layers.get(0));
            return;
        }
        WorkspaceInfo defaultWs = catalog.getDefaultWorkspace();
        if (defaultWs != null && (defaultStore = catalog.getDefaultDataStore(defaultWs)) != null) {
            List resources = catalog.getResourcesByStore((StoreInfo)defaultStore, ResourceInfo.class);
            for (ResourceInfo resource : resources) {
                layers = catalog.getLayers(resource);
                if (layers.size() <= 0) continue;
                this.layerModel = new Model((Serializable)layers.get(0));
                return;
            }
        }
        if ((layers = catalog.getLayers()).size() > 0) {
            this.layerModel = new Model((Serializable)layers.get(0));
            return;
        }
        this.layerModel = new Model((Serializable)new LayerInfoImpl());
    }

    protected void initUI(final StyleInfo style) {
        if (style == null) {
            this.styleModel = new CompoundPropertyModel((Object)this.getCatalog().getFactory().createStyle());
            ((StyleInfo)this.styleModel.getObject()).setName("");
            ((StyleInfo)this.styleModel.getObject()).setLegend(this.getCatalog().getFactory().createLegend());
        } else {
            if (style.getLegend() == null) {
                style.setLegend(this.getCatalog().getFactory().createLegend());
            }
            this.styleModel = new CompoundPropertyModel((Object)style);
        }
        this.styleForm = new Form<StyleInfo>("styleForm", this.styleModel){

            protected void onSubmit() {
                AbstractStylePage.this.onStyleFormSubmit();
                super.onSubmit();
            }
        };
        this.add(new Component[]{this.styleForm});
        this.styleForm.setMultiPart(true);
        this.popup = new ModalWindow("popup");
        this.styleForm.add(new Component[]{this.popup});
        ArrayList<Object> tabs = new ArrayList<Object>();
        PanelCachingTab dataTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Data"))){

            public Panel getPanel(String id) {
                return new StyleAdminPanel(id, AbstractStylePage.this);
            }
        });
        PanelCachingTab publishingTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Publishing"))){
            private static final long serialVersionUID = 4184410057835108176L;

            public Panel getPanel(String id) {
                return new LayerAssociationPanel(id, AbstractStylePage.this);
            }
        });
        PanelCachingTab previewTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Layer Preview"))){

            public Panel getPanel(String id) {
                return new OpenLayersPreviewPanel(id, AbstractStylePage.this);
            }
        });
        PanelCachingTab attributeTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Layer Attributes"))){
            private static final long serialVersionUID = 4184410057835108176L;

            public Panel getPanel(String id) {
                try {
                    return new LayerAttributePanel(id, AbstractStylePage.this);
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        });
        tabs.add(dataTab);
        if (style != null) {
            tabs.add(publishingTab);
            tabs.add(previewTab);
            tabs.add(attributeTab);
        }
        List tabPanels = this.getGeoServerApplication().getBeansOfType(StyleEditTabPanelInfo.class);
        Collections.sort(tabPanels, new Comparator<StyleEditTabPanelInfo>(){

            @Override
            public int compare(StyleEditTabPanelInfo o1, StyleEditTabPanelInfo o2) {
                Integer order1 = o1.getOrder() >= 0 ? o1.getOrder() : Integer.MAX_VALUE;
                Integer order2 = o2.getOrder() >= 0 ? o2.getOrder() : Integer.MAX_VALUE;
                return order1.compareTo(order2);
            }
        });
        for (StyleEditTabPanelInfo tabPanelInfo : tabPanels) {
            String titleKey = tabPanelInfo.getTitleKey();
            Object titleModel = null;
            if (!tabPanelInfo.isEnabledOnNew() && style == null) continue;
            titleModel = titleKey != null ? new ResourceModel(titleKey) : new Model((Serializable)((Object)tabPanelInfo.getComponentClass().getSimpleName()));
            final Class panelClass = tabPanelInfo.getComponentClass();
            tabs.add(new AbstractTab((IModel)titleModel){
                private static final long serialVersionUID = -6637277497986497791L;

                public Panel getPanel(String panelId) {
                    StyleEditTabPanel tabPanel;
                    try {
                        tabPanel = (StyleEditTabPanel)((Object)panelClass.getConstructor(String.class, IModel.class).newInstance(panelId, AbstractStylePage.this.styleModel));
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                    return tabPanel;
                }
            });
        }
        this.tabbedPanel = new AjaxTabbedPanel<ITab>("context", tabs){

            protected String getTabContainerCssClass() {
                return "tab-row tab-row-compact";
            }

            protected WebMarkupContainer newLink(String linkId, final int index) {
                AjaxSubmitLink link = new AjaxSubmitLink(linkId){
                    private static final long serialVersionUID = 1L;

                    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                        if (AbstractStylePage.this.getLayerInfo() == null || AbstractStylePage.this.getLayerInfo().getId() == null) {
                            switch (index) {
                                case 1: {
                                    AbstractStylePage.this.tabbedPanel.error((Serializable)((Object)"Cannot show Publishing options: No Layers available."));
                                    AbstractStylePage.this.addFeedbackPanels(target);
                                    return;
                                }
                                case 2: {
                                    AbstractStylePage.this.tabbedPanel.error((Serializable)((Object)"Cannot show Layer Preview: No Layers available."));
                                    AbstractStylePage.this.addFeedbackPanels(target);
                                    return;
                                }
                                case 3: {
                                    AbstractStylePage.this.tabbedPanel.error((Serializable)((Object)"Cannot show Attribute Preview: No Layers available."));
                                    AbstractStylePage.this.addFeedbackPanels(target);
                                    return;
                                }
                            }
                        }
                        this.setSelectedTab(index);
                        target.add(new Component[]{AbstractStylePage.this.tabbedPanel});
                    }
                };
                link.setDefaultFormProcessing(false);
                return link;
            }
        };
        this.tabbedPanel.setMarkupId("style-context");
        this.tabbedPanel.setOutputMarkupId(true);
        this.styleForm.add(new Component[]{this.tabbedPanel});
        Component[] componentArray = new Component[1];
        this.editor = new CodeMirrorEditor("styleEditor", this.styleHandler().getCodeMirrorEditMode(), (IModel)new PropertyModel((Object)this, "rawStyle"));
        componentArray[0] = this.editor;
        this.styleForm.add(componentArray);
        this.editor.setTextAreaMarkupId("editor");
        this.editor.setMarkupId("style-editor");
        this.editor.setOutputMarkupId(true);
        this.editor.setRequired(true);
        this.styleForm.add(new Component[]{this.editor});
        GeoServerDialog dialog = new GeoServerDialog("dialog");
        dialog.setOutputMarkupId(true);
        this.add(new Component[]{dialog});
        GeoServerDialog.DialogDelegate imagePanelDelegate = new GeoServerDialog.DialogDelegate(){
            private ChooseImagePanel imagePanel;

            protected Component getContents(String id) {
                this.imagePanel = new ChooseImagePanel(id, ((StyleInfo)AbstractStylePage.this.styleModel.getObject()).getWorkspace());
                return this.imagePanel;
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                String imageFileName = this.imagePanel.getChoice();
                if (Strings.isEmpty((CharSequence)imageFileName)) {
                    FileUpload fu = this.imagePanel.getFileUpload();
                    imageFileName = fu.getClientFileName();
                    int teller = 0;
                    GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerApplication.get().getBeanOfType(GeoServerDataDirectory.class);
                    Resource res = dd.getStyles(style.getWorkspace(), new String[]{imageFileName});
                    while (Resources.exists((Resource)res)) {
                        imageFileName = FilenameUtils.getBaseName((String)fu.getClientFileName()) + "." + ++teller + "." + FilenameUtils.getExtension((String)fu.getClientFileName());
                        res = dd.getStyles(style.getWorkspace(), new String[]{imageFileName});
                    }
                    try (InputStream is = fu.getInputStream();
                         OutputStream os = res.out();){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    catch (IOException e) {
                        AbstractStylePage.this.error((Serializable)((Object)e.getMessage()));
                        target.add(new Component[]{this.imagePanel.getFeedback()});
                        return false;
                    }
                }
                target.appendJavaScript((CharSequence)("replaceSelection('" + AbstractStylePage.this.styleHandler().insertImageCode(imageFileName) + "');"));
                return true;
            }

            public void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{this.imagePanel.getFeedback()});
            }
        };
        this.editor.addCustomButton(new ParamResourceModel("insertImage", (Component)this.getPage(), new Object[0]).getString(), "button-picture", (CodeMirrorEditor.CustomButtonAction & Serializable)target -> {
            dialog.setTitle((IModel)new ParamResourceModel("insertImage", (Component)this.getPage(), new Object[0]));
            dialog.setInitialWidth(385);
            dialog.setInitialHeight(175);
            dialog.showOkCancel(target, imagePanelDelegate);
        });
        this.editor.addCustomButton(new ParamResourceModel("chooseColor", (Component)this.getPage(), new Object[0]).getString(), "button-color", (CodeMirrorEditor.CustomButtonAction & Serializable)target -> {
            IRequestParameters queryParameters = target.getPage().getRequest().getQueryParameters();
            StringValue cmSelection = queryParameters.getParameterValue("cmSelection");
            final String defaultColor = cmSelection != null ? cmSelection.toString() : "#000";
            dialog.setTitle((IModel)new ParamResourceModel("chooseColor", (Component)this.getPage(), new Object[0]));
            dialog.setInitialWidth(410);
            dialog.setInitialHeight(270);
            dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                private ChooseColorPanel chooserPanel;

                protected Component getContents(String id) {
                    this.chooserPanel = new ChooseColorPanel(id, defaultColor);
                    return this.chooserPanel;
                }

                protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                    String chosenColor = (String)this.chooserPanel.chooser.getModelObject();
                    if (chosenColor != null) {
                        if (HEX_COLOR.matcher("#" + defaultColor).matches() && chosenColor.startsWith("#")) {
                            chosenColor = chosenColor.substring(1);
                        }
                        target.appendJavaScript((CharSequence)("replaceSelection('" + chosenColor + "');"));
                    }
                    return true;
                }
            });
        });
        this.add(new Component[]{this.validateLink()});
        this.add(new Component[]{new AjaxSubmitLink("apply", this.styleForm){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                if (style == null) {
                    StyleInfo s = AbstractStylePage.this.getStyleInfo();
                    PageParameters parameters = new PageParameters();
                    parameters.add("name", (Object)s.getName());
                    if (s.getWorkspace() != null) {
                        parameters.add("workspace", (Object)s.getWorkspace().getName());
                    }
                    this.getRequestCycle().setResponsePage(StyleEditPage.class, parameters);
                }
                AbstractStylePage.this.addFeedbackPanels(target);
                if (style != null && AbstractStylePage.this.tabbedPanel.getSelectedTab() == 2) {
                    AbstractStylePage.this.tabbedPanel.visitChildren(StyleEditTabPanel.class, (component, visit) -> {
                        if (component instanceof OpenLayersPreviewPanel) {
                            OpenLayersPreviewPanel previewPanel = (OpenLayersPreviewPanel)((Object)component);
                            try {
                                target.appendJavaScript((CharSequence)previewPanel.getUpdateCommand());
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINER, e.getMessage(), e);
                            }
                        }
                    });
                }
            }

            protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
                if (((StyleInfo)AbstractStylePage.this.styleModel.getObject()).getLegend() == null) {
                    ((StyleInfo)AbstractStylePage.this.styleModel.getObject()).setLegend(AbstractStylePage.this.getCatalog().getFactory().createLegend());
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                AbstractStylePage.this.addFeedbackPanels(target);
            }
        }});
        this.add(new Component[]{new AjaxSubmitLink("submit", this.styleForm){

            protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
                if (form.hasError()) {
                    AbstractStylePage.this.addFeedbackPanels(target);
                } else {
                    AbstractStylePage.this.doReturn(StylePage.class);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                AbstractStylePage.this.addFeedbackPanels(target);
            }
        }});
        Link<StylePage> cancelLink = new Link<StylePage>("cancel"){

            public void onClick() {
                AbstractStylePage.this.doReturn(StylePage.class);
            }
        };
        this.add(new Component[]{cancelLink});
    }

    StyleHandler styleHandler() {
        String format = ((StyleInfo)this.styleModel.getObject()).getFormat();
        return Styles.handler((String)format);
    }

    Component validateLink() {
        return new GeoServerAjaxFormLink("validate", this.styleForm){

            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                AbstractStylePage.this.editor.processInput();
                List<Exception> errors = AbstractStylePage.this.validateSLD();
                if (errors.isEmpty()) {
                    form.info((Serializable)((Object)"No validation errors."));
                } else {
                    for (Exception e : errors) {
                        form.error((Serializable)((Object)AbstractStylePage.this.sldErrorWithLineNo(e)));
                    }
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(AbstractStylePage.this.editor.getSaveDecorator());
            }
        };
    }

    private String sldErrorWithLineNo(Exception e) {
        if (e instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)e;
            return "line " + se.getLineNumber() + ": " + e.getLocalizedMessage();
        }
        String message = e.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        return new ParamResourceModel("genericError", (Component)this, new Object[0]).getString();
    }

    List<Exception> validateSLD() {
        try {
            String style = this.editor.getInput();
            ByteArrayInputStream input = new ByteArrayInputStream(style.getBytes());
            List validationErrors = this.styleHandler().validate((Object)input, null, this.getCatalog().getResourcePool().getEntityResolver());
            input = new ByteArrayInputStream(style.getBytes());
            StyledLayerDescriptor sld = this.styleHandler().parse((Object)input, null, null, this.getCatalog().getResourcePool().getEntityResolver());
            if (sld.getStyledLayers().length > 1) {
                validationErrors.addAll(SLDNamedLayerValidator.validate((Catalog)this.getCatalog(), (StyledLayerDescriptor)sld));
            }
            return validationErrors;
        }
        catch (Exception e) {
            return Arrays.asList(e);
        }
    }

    Reader readFile(StyleInfo style) throws IOException {
        ResourcePool pool = this.getCatalog().getResourcePool();
        return pool.readStyle(style);
    }

    public void setRawStyle(Reader in) throws IOException {
        BufferedReader bin = null;
        bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = bin.readLine()) != null) {
            builder.append(line).append("\n");
        }
        this.rawStyle = builder.toString();
        this.editor.setModelObject((Object)this.rawStyle);
        in.close();
    }

    protected void recoverCssStyle(StyleInfo si) {
        if (si == null) {
            return;
        }
        try {
            Styles.handler((String)"css");
        }
        catch (Exception e) {
            return;
        }
        long favorSLDIfNewerByMS = 600000L;
        if ("sld".equalsIgnoreCase(si.getFormat())) {
            String filename = si.getFilename();
            String filenameCss = filename.substring(0, filename.lastIndexOf(46)) + ".css";
            GeoServerDataDirectory dataDir = new GeoServerDataDirectory(this.getCatalog().getResourceLoader());
            Resource cssResource = dataDir.get(si, new String[]{filenameCss});
            if (!cssResource.getType().equals((Object)Resource.Type.UNDEFINED)) {
                Resource sldResource = dataDir.get(si, new String[]{filename});
                long sldNewerByMs = sldResource.lastmodified() - cssResource.lastmodified();
                if (sldNewerByMs > favorSLDIfNewerByMS) {
                    LOGGER.log(Level.WARNING, "A CSS version of " + si.getName() + " has been recovered (" + filenameCss + "), but the SLD is more recent by " + sldNewerByMs + " ms. The style will be left as an SLD.");
                } else {
                    LOGGER.log(Level.WARNING, "A CSS version of " + si.getName() + " has been recovered (" + filenameCss + "). The style will be converted to CSS.");
                    si.setFilename(filenameCss);
                    si.setFormat("css");
                    this.getCatalog().save(si);
                }
            }
        }
    }

    protected void configurationChanged() {
        this.tabbedPanel.visitChildren(StyleEditTabPanel.class, (component, visit) -> {
            if (component instanceof StyleEditTabPanel) {
                ((StyleEditTabPanel)((Object)component)).configurationChanged();
            }
        });
    }

    protected abstract void onStyleFormSubmit();

    protected ModalWindow getPopup() {
        return this.popup;
    }

    protected IModel<LayerInfo> getLayerModel() {
        return this.layerModel;
    }

    protected CompoundPropertyModel<StyleInfo> getStyleModel() {
        return this.styleModel;
    }

    public LayerInfo getLayerInfo() {
        return (LayerInfo)this.layerModel.getObject();
    }

    public StyleInfo getStyleInfo() {
        return (StyleInfo)this.styleModel.getObject();
    }

    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    protected boolean isAuthenticatedAsAdmin() {
        return super.isAuthenticatedAsAdmin();
    }

    protected Catalog getCatalog() {
        return super.getCatalog();
    }

    protected GeoServer getGeoServer() {
        return super.getGeoServer();
    }

    protected GeoServerApplication getGeoServerApplication() {
        return super.getGeoServerApplication();
    }

    class ChooseImagePanel
    extends Panel {
        private WorkspaceInfo ws;

        public ChooseImagePanel(String id, WorkspaceInfo ws) {
            super(id);
            this.ws = ws;
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
            TreeSet<String> imageSet = new TreeSet<String>();
            GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerApplication.get().getBeanOfType(GeoServerDataDirectory.class);
            for (Resource r : dd.getStyles(this.ws, new String[0]).list()) {
                if (!ArrayUtils.contains((Object[])AbstractStylePage.this.styleHandler().imageExtensions(), (Object)FilenameUtils.getExtension((String)r.name()).toLowerCase())) continue;
                imageSet.add(r.name());
            }
            final FileUploadField upload = new FileUploadField("upload", (IModel)new Model());
            final Model imageModel = new Model();
            final DropDownChoice image = new DropDownChoice("image", (IModel)imageModel, new ArrayList(imageSet));
            final URI stylesDir = dd.getStyles(this.ws, new String[0]).dir().toURI();
            final Image display = new Image("display", (IModel)new IModel<ResourceReference>(){

                public ResourceReference getObject() {
                    if (imageModel.getObject() != null) {
                        try {
                            return new FileSystemResourceReference((String)((Object)imageModel.getObject()), FileSystemResourceReference.getPath((URI)stylesDir.resolve((String)((Object)imageModel.getObject()))));
                        }
                        catch (IOException | URISyntaxException e) {
                            LOGGER.log(Level.WARNING, e.getMessage(), e);
                            return null;
                        }
                    }
                    return null;
                }

                public void setObject(ResourceReference object) {
                }

                public void detach() {
                }
            });
            display.setOutputMarkupPlaceholderTag(true).setVisible(false);
            image.setNullValid(true).setOutputMarkupId(true).add(new Behavior[]{new OnChangeAjaxBehavior(){

                protected void onUpdate(AjaxRequestTarget target) {
                    upload.setModelObject(null);
                    display.setVisible(image.getModelObject() != null);
                    target.add(new Component[]{upload});
                    target.add(new Component[]{display});
                }
            }});
            upload.setOutputMarkupId(true).add(new Behavior[]{new OnChangeAjaxBehavior(){

                protected void onUpdate(AjaxRequestTarget target) {
                    image.setModelObject(null);
                    display.setVisible(false);
                    target.add(new Component[]{image});
                    target.add(new Component[]{display});
                }
            }});
            this.add(new Component[]{image});
            this.add(new Component[]{display});
            this.add(new Component[]{upload});
            ((Form)this.findParent(Form.class)).add((IFormValidator)new AbstractFormValidator(){

                public FormComponent<?>[] getDependentFormComponents() {
                    return new FormComponent[]{image, upload};
                }

                public void validate(Form<?> form) {
                    if (image.getConvertedInput() == null && (upload.getConvertedInput() == null || ((List)upload.getConvertedInput()).isEmpty())) {
                        form.error((Serializable)((Object)new ParamResourceModel("missingImage", (Component)ChooseImagePanel.this.getPage(), new Object[0]).getString()));
                    }
                }
            });
        }

        public String getChoice() {
            return this.get("image").getDefaultModelObjectAsString();
        }

        public FileUpload getFileUpload() {
            return ((FileUploadField)this.get("upload")).getFileUpload();
        }

        public FeedbackPanel getFeedback() {
            return (FeedbackPanel)this.get("feedback");
        }
    }

    static class ChooseColorPanel
    extends Panel {
        final TextField<String> chooser = new TextField("chooser", (IModel)new Model());
        final String initialColor;

        public ChooseColorPanel(String id, String initialColor) {
            super(id);
            this.chooser.setOutputMarkupId(true);
            this.initialColor = initialColor;
            this.add(new Component[]{this.chooser});
        }

        public void renderHead(IHeaderResponse response) {
            super.renderHead(response);
            response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)new PackageResourceReference(AbstractStylePage.class, "js/spectrum/spectrum.css")));
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(AbstractStylePage.class, "js/spectrum/spectrum.js")));
            String enableSpectrum = "$(\"#chooser\").spectrum({\n    color: \"" + this.initialColor + "\",\n    showInput: true,\n    flat: true,\n    className: \"full-spectrum\",\n    showInitial: true,\n    showPalette: true,\n    showSelectionPalette: true,\n    showButtons: false,\n    preferredFormat: \"hex\",\n    clickoutFiresChange: true,\n    palette: [\n        [\"#000\",\"#444\",\"#666\",\"#999\",\"#ccc\",\"#eee\",\"#f3f3f3\",\"#fff\"],\n        [\"#f00\",\"#f90\",\"#ff0\",\"#0f0\",\"#0ff\",\"#00f\",\"#90f\",\"#f0f\"],\n        [\"#f4cccc\",\"#fce5cd\",\"#fff2cc\",\"#d9ead3\",\"#d0e0e3\",\"#cfe2f3\",\"#d9d2e9\",\"#ead1dc\"],\n        [\"#ea9999\",\"#f9cb9c\",\"#ffe599\",\"#b6d7a8\",\"#a2c4c9\",\"#9fc5e8\",\"#b4a7d6\",\"#d5a6bd\"],\n        [\"#e06666\",\"#f6b26b\",\"#ffd966\",\"#93c47d\",\"#76a5af\",\"#6fa8dc\",\"#8e7cc3\",\"#c27ba0\"],\n        [\"#c00\",\"#e69138\",\"#f1c232\",\"#6aa84f\",\"#45818e\",\"#3d85c6\",\"#674ea7\",\"#a64d79\"],\n        [\"#900\",\"#b45f06\",\"#bf9000\",\"#38761d\",\"#134f5c\",\"#0b5394\",\"#351c75\",\"#741b47\"],\n        [\"#600\",\"#783f04\",\"#7f6000\",\"#274e13\",\"#0c343d\",\"#073763\",\"#20124d\",\"#4c1130\"]],\n    move: function (color) {\n          $(\"#chooser\").spectrum(\"set\", color);\n    }\n});";
            response.render((HeaderItem)new OnDomReadyHeaderItem((CharSequence)enableSpectrum));
        }
    }
}

