/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.data.store.panel.FileModel;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.FileExistsValidator;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SRSListTextArea;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.web.MimeTypesFormComponent;
import org.geoserver.wms.web.publish.LayerAuthoritiesAndIdentifiersPanel;

public class WMSAdminPage
extends BaseServiceAdminPage<WMSInfo> {
    static final List<String> SVG_RENDERERS = Arrays.asList("Batik", "Simple");
    static final List<String> KML_REFLECTOR_MODES = Arrays.asList("refresh", "superoverlay", "download");
    static final List<String> KML_SUPEROVERLAY_MODES = Arrays.asList("auto", "raster", "overview", "hybrid", "cached");
    static final List<String> DISPOSAL_METHODS = new ArrayList<String>(Arrays.asList(WMS.DISPOSAL_METHODS));
    ModalWindow modal;
    MimeTypesFormComponent getMapMimeTypesComponent;
    MimeTypesFormComponent getFeatureInfoMimeTypesComponent;
    TreeSet<String> getMapAvailable;
    TreeSet<String> getFeatureInfoAvailable;

    public WMSAdminPage() {
    }

    public WMSAdminPage(PageParameters pageParams) {
        super(pageParams);
    }

    public WMSAdminPage(WMSInfo service) {
        super((ServiceInfo)service);
    }

    protected Class<WMSInfo> getServiceClass() {
        return WMSInfo.class;
    }

    protected void build(IModel info, Form form) {
        Component[] componentArray = new Component[1];
        this.modal = new ModalWindow("modal");
        componentArray[0] = this.modal;
        form.add(componentArray);
        form.add(new Component[]{new TextField("rootLayerTitle")});
        form.add(new Component[]{new TextArea("rootLayerAbstract")});
        LayerAuthoritiesAndIdentifiersPanel authAndIds = new LayerAuthoritiesAndIdentifiersPanel("authoritiesAndIds", true, (IModel<? extends CatalogInfo>)info);
        form.add(new Component[]{authAndIds});
        SRSListTextArea srsList = new SRSListTextArea("srs", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)info, "sRS")));
        form.add(new Component[]{srsList});
        form.add(new Component[]{new CheckBox("bBOXForEachCRS")});
        form.add(new Component[]{new AjaxLink("bBOXForEachCRSHelp"){

            public void onClick(AjaxRequestTarget target) {
                WMSAdminPage.this.dialog.showInfo(target, (IModel)new StringResourceModel("bboxForEachCRSHelp.title", (Component)WMSAdminPage.this, null), new IModel[]{new StringResourceModel("bboxForEachCRSHelp.message", (Component)WMSAdminPage.this, null)});
            }
        }});
        PropertyModel metadataModel = new PropertyModel((Object)info, "metadata");
        MapModel aphEnabled = this.defaultedModel((IModel)metadataModel, WMS.ADVANCED_PROJECTION_KEY, WMS.ENABLE_ADVANCED_PROJECTION);
        CheckBox aphEnabledField = new CheckBox("aph.enabled", (IModel)aphEnabled);
        form.add(new Component[]{aphEnabledField});
        MapModel aphWrap = this.defaultedModel((IModel)metadataModel, WMS.MAP_WRAPPING_KEY, WMS.ENABLE_MAP_WRAPPING);
        CheckBox aphWrapField = new CheckBox("aph.wrap", (IModel)aphWrap);
        form.add(new Component[]{aphWrapField});
        form.add(new Component[]{new DropDownChoice("interpolation", Arrays.asList(WMSInfo.WMSInterpolation.values()), (IChoiceRenderer)new InterpolationRenderer())});
        TextField maxMemory = new TextField("maxRequestMemory");
        maxMemory.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxMemory});
        TextField maxTime = new TextField("maxRenderingTime");
        maxTime.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxTime});
        TextField maxErrors = new TextField("maxRenderingErrors");
        maxErrors.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxErrors});
        TextField maxBuffer = new TextField("maxBuffer");
        maxBuffer.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxBuffer});
        TextField maxRequestedDimensionValues = new TextField("maxRequestedDimensionValues");
        maxRequestedDimensionValues.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxRequestedDimensionValues});
        form.add(new Component[]{new CheckBox("watermark.enabled")});
        TextField watermarkUrlField = new TextField("watermark.uRL", (IModel)new FileModel((IModel)new PropertyModel((Object)form.getModel(), "watermark.URL")));
        watermarkUrlField.add((IValidator)new FileExistsValidator(true));
        watermarkUrlField.setOutputMarkupId(true);
        form.add(new Component[]{watermarkUrlField});
        form.add(new Component[]{this.chooserButton("chooser", new ParamResourceModel("chooseWatermark", (Component)this, new Object[0]).getString(), (TextField<String>)watermarkUrlField)});
        TextField transparency = new TextField("watermark.transparency");
        transparency.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{transparency});
        form.add(new Component[]{new DropDownChoice("watermark.position", Arrays.asList(WatermarkInfo.Position.values()), (IChoiceRenderer)new WatermarkPositionRenderer())});
        form.add(new Component[]{new CheckBox("svg.antialias", (IModel)new MapModel((IModel)metadataModel, "svgAntiAlias"))});
        form.add(new Component[]{new DropDownChoice("svg.producer", (IModel)new MapModel((IModel)metadataModel, "svgRenderer"), SVG_RENDERERS, (IChoiceRenderer)new SVGMethodRenderer())});
        MapModel pngCompression = this.defaultedModel((IModel)metadataModel, "pngCompression", 25);
        TextField pngCompressionField = new TextField("png.compression", (IModel)pngCompression, Integer.class);
        pngCompressionField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{pngCompressionField});
        MapModel jpegCompression = this.defaultedModel((IModel)metadataModel, "jpegCompression", 25);
        TextField jpegCompressionField = new TextField("jpeg.compression", (IModel)jpegCompression, Integer.class);
        jpegCompressionField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{jpegCompressionField});
        MapModel maxAllowedFrames = this.defaultedModel((IModel)metadataModel, "maxAllowedFrames", Integer.MAX_VALUE);
        TextField maxAllowedFramesField = new TextField("anim.maxallowedframes", (IModel)maxAllowedFrames, Integer.class);
        maxAllowedFramesField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        form.add(new Component[]{maxAllowedFramesField});
        MapModel maxRenderingTime = this.defaultedModel((IModel)metadataModel, "maxAnimatorRenderingTime", null);
        TextField maxRenderingTimeField = new TextField("anim.maxrenderingtime", (IModel)maxRenderingTime, Integer.class);
        form.add(new Component[]{maxRenderingTimeField});
        MapModel maxRenderingSize = this.defaultedModel((IModel)metadataModel, "maxRenderingSize", null);
        TextField maxRenderingSizeField = new TextField("anim.maxrenderingsize", (IModel)maxRenderingSize, Integer.class);
        form.add(new Component[]{maxRenderingSizeField});
        MapModel framesDelay = this.defaultedModel((IModel)metadataModel, "framesDelay", 1000);
        TextField framesDelayField = new TextField("anim.framesdelay", (IModel)framesDelay, Integer.class);
        framesDelayField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        form.add(new Component[]{framesDelayField});
        MapModel disposalMethod = this.defaultedModel((IModel)metadataModel, "disposalMethod", "none");
        form.add(new Component[]{new DropDownChoice("anim.disposalmethod", (IModel)disposalMethod, DISPOSAL_METHODS)});
        MapModel loopContinuously = this.defaultedModel((IModel)metadataModel, "loopContinuously", WMS.LOOP_CONTINUOUSLY_DEFAULT);
        CheckBox loopContinuouslyField = new CheckBox("anim.loopcontinuously", (IModel)loopContinuously);
        form.add(new Component[]{loopContinuouslyField});
        MapModel kmlReflectorMode = this.defaultedModel((IModel)metadataModel, WMS.KML_REFLECTOR_MODE, "refresh");
        form.add(new Component[]{new DropDownChoice("kml.defaultReflectorMode", (IModel)kmlReflectorMode, KML_REFLECTOR_MODES)});
        MapModel kmlSuperoverlayMode = this.defaultedModel((IModel)metadataModel, "kmlSuperoverlayMode", "auto");
        form.add(new Component[]{new DropDownChoice("kml.superoverlayMode", (IModel)kmlSuperoverlayMode, KML_SUPEROVERLAY_MODES)});
        form.add(new Component[]{new CheckBox("kml.kmattr", (IModel)this.defaultedModel((IModel)metadataModel, "kmlAttr", true))});
        form.add(new Component[]{new CheckBox("kml.kmlplacemark", (IModel)this.defaultedModel((IModel)metadataModel, "kmlPlacemark", false))});
        MapModel kmScore = this.defaultedModel((IModel)metadataModel, "kmlKmscore", 40);
        TextField kmScoreField = new TextField("kml.kmscore", (IModel)kmScore, Integer.class);
        kmScoreField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{kmScoreField});
        form.add(new Component[]{new CheckBox("scalehint.mapunitsPixel", (IModel)this.defaultedModel((IModel)metadataModel, "scalehintMapunitsPixel", WMS.SCALEHINT_MAPUNITS_PIXEL_DEFAULT))});
        this.getMapAvailable = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (GetMapOutputFormat format : GeoServerExtensions.extensions(GetMapOutputFormat.class)) {
            this.getMapAvailable.add(format.getMimeType());
        }
        ArrayList getMapSelected = new ArrayList();
        getMapSelected.addAll((Collection)new PropertyModel((Object)info, "getMapMimeTypes").getObject());
        ArrayList<String> getMapChoices = new ArrayList<String>();
        getMapChoices.addAll(this.getMapAvailable);
        Component[] componentArray2 = new Component[1];
        this.getMapMimeTypesComponent = new MimeTypesFormComponent("getMapMimeTypes", (IModel<List<String>>)new ListModel(getMapSelected), (IModel<Collection<String>>)new CollectionModel(getMapChoices), (Boolean)new PropertyModel((Object)info, "getMapMimeTypeCheckingEnabled").getObject());
        componentArray2[0] = this.getMapMimeTypesComponent;
        form.add(componentArray2);
        this.getFeatureInfoAvailable = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (GetFeatureInfoOutputFormat format : GeoServerExtensions.extensions(GetFeatureInfoOutputFormat.class)) {
            this.getFeatureInfoAvailable.add(format.getContentType());
        }
        ArrayList getFeatureInfoSelected = new ArrayList();
        getFeatureInfoSelected.addAll((Collection)new PropertyModel((Object)info, "getFeatureInfoMimeTypes").getObject());
        ArrayList<String> getFeatureInfoChoices = new ArrayList<String>();
        getFeatureInfoChoices.addAll(this.getFeatureInfoAvailable);
        Component[] componentArray3 = new Component[1];
        this.getFeatureInfoMimeTypesComponent = new MimeTypesFormComponent("getFeatureInfoMimeTypes", (IModel<List<String>>)new ListModel(getFeatureInfoSelected), (IModel<Collection<String>>)new CollectionModel(getFeatureInfoChoices), (Boolean)new PropertyModel((Object)info, "getFeatureInfoMimeTypeCheckingEnabled").getObject());
        componentArray3[0] = this.getFeatureInfoMimeTypesComponent;
        form.add(componentArray3);
        form.add(new Component[]{new CheckBox("dynamicStyling.disabled", (IModel)new PropertyModel((Object)info, "dynamicStylingDisabled"))});
        form.add(new Component[]{new CheckBox("disableFeaturesReproject", (IModel)new PropertyModel((Object)info, "featuresReprojectionDisabled"))});
        TextField cacheMaxExtries = new TextField("cacheConfiguration.maxEntries");
        cacheMaxExtries.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{cacheMaxExtries});
        TextField cacheEntrySize = new TextField("cacheConfiguration.maxEntrySize");
        cacheEntrySize.add((IValidator)new RangeValidator((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(Long.MAX_VALUE)));
        form.add(new Component[]{cacheEntrySize});
        form.add(new Component[]{new CheckBox("cacheConfiguration.enabled")});
    }

    protected void handleSubmit(WMSInfo info) {
        info.setGetMapMimeTypeCheckingEnabled(this.getMapMimeTypesComponent.isMimeTypeCheckingEnabled());
        if (info.isGetMapMimeTypeCheckingEnabled()) {
            info.getGetMapMimeTypes().addAll(this.getMapMimeTypesComponent.getPalette().getModelCollection());
        } else {
            info.getGetMapMimeTypes().clear();
        }
        info.setGetFeatureInfoMimeTypeCheckingEnabled(this.getFeatureInfoMimeTypesComponent.isMimeTypeCheckingEnabled());
        if (info.isGetFeatureInfoMimeTypeCheckingEnabled()) {
            info.getGetFeatureInfoMimeTypes().addAll(this.getFeatureInfoMimeTypesComponent.getPalette().getModelCollection());
        } else {
            info.getGetFeatureInfoMimeTypes().clear();
        }
        super.handleSubmit((ServiceInfo)info);
    }

    protected Component chooserButton(String linkId, final String windowTitle, final TextField<String> textField) {
        AjaxSubmitLink link = new AjaxSubmitLink(linkId){

            public boolean getDefaultFormProcessing() {
                return false;
            }

            public void onSubmit(AjaxRequestTarget target, Form form) {
                File file = null;
                textField.processInput();
                String input = (String)textField.getConvertedInput();
                if (input != null && !input.equals("")) {
                    file = new File(input);
                }
                GeoServerFileChooser chooser = new GeoServerFileChooser(WMSAdminPage.this.modal.getContentId(), (IModel)new Model((Serializable)file)){

                    protected void fileClicked(File file, AjaxRequestTarget target) {
                        textField.clearInput();
                        textField.setModelObject((Object)file.getAbsolutePath());
                        target.add(new Component[]{textField});
                        WMSAdminPage.this.dialog.close(target);
                    }
                };
                chooser.setFileTableHeight(null);
                WMSAdminPage.this.modal.setContent((Component)chooser);
                WMSAdminPage.this.modal.setTitle(windowTitle);
                WMSAdminPage.this.modal.show((IPartialPageRequestHandler)target);
            }
        };
        return link;
    }

    MapModel defaultedModel(IModel baseModel, String key, Object defaultValue) {
        MapModel model = new MapModel(baseModel, key);
        if (model.getObject() == null) {
            model.setObject(defaultValue);
        }
        return model;
    }

    protected String getServiceName() {
        return "WMS";
    }

    private class SVGMethodRenderer
    extends ChoiceRenderer {
        private SVGMethodRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel("svg." + object, (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return (String)object;
        }
    }

    private class InterpolationRenderer
    extends ChoiceRenderer {
        private InterpolationRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((WMSInfo.WMSInterpolation)object).name(), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((WMSInfo.WMSInterpolation)object).name();
        }
    }

    private class WatermarkPositionRenderer
    extends ChoiceRenderer {
        private WatermarkPositionRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((WatermarkInfo.Position)object).name(), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((WatermarkInfo.Position)object).name();
        }
    }
}

