/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data.publish;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.publish.StylesModel;
import org.geoserver.wms.web.publish.WMSLayerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WMSLayerConfigTest
extends GeoServerWicketTestSupport {
    @Before
    public void resetPondStyle() {
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName(MockData.PONDS.getLocalPart());
        style.setWorkspace(null);
        catalog.save(style);
    }

    @Test
    public void testExisting() {
        final LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        FormTestPage page = new FormTestPage(new ComponentBuilder(){

            public Component buildComponent(String id) {
                return new WMSLayerConfig(id, (IModel)new Model((Serializable)layer));
            }
        });
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:styles:defaultStyle", DropDownChoice.class);
        StyleInfo target = (StyleInfo)((List)new StylesModel().getObject()).get(0);
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:styles:defaultStyle", 0);
        ft.submit();
        tester.assertModelValue("form:panel:styles:defaultStyle", (Object)target);
    }

    @Test
    public void testNew() {
        final LayerInfo layer = this.getCatalog().getFactory().createLayer();
        layer.setResource((ResourceInfo)this.getCatalog().getFactory().createFeatureType());
        FormTestPage page = new FormTestPage(new ComponentBuilder(){

            public Component buildComponent(String id) {
                return new WMSLayerConfig(id, (IModel)new Model((Serializable)layer));
            }
        });
        Component layerConfig = page.get("form:panel:styles:defaultStyle");
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:styles:defaultStyle", DropDownChoice.class);
        tester.submitForm("form");
        Assert.assertTrue((boolean)layerConfig.getFeedbackMessages().hasMessage(400));
        page.getSession().getFeedbackMessages().clear();
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:styles:defaultStyle", 0);
        ft.submit();
        Assert.assertFalse((boolean)layerConfig.getFeedbackMessages().hasMessage(400));
    }

    @Test
    public void testLegendGraphicURL() throws Exception {
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName(MockData.PONDS.getLocalPart());
        WorkspaceInfo ws = catalog.getWorkspaceByName(MockData.PONDS.getPrefix());
        style.setWorkspace(ws);
        catalog.save(style);
        final LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        FormTestPage page = new FormTestPage(new ComponentBuilder(){

            public Component buildComponent(String id) {
                return new WMSLayerConfig(id, (IModel)new Model((Serializable)layer));
            }
        });
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.debugComponentTrees();
        Image img = (Image)tester.getComponentFromLastRenderedPage("form:panel:styles:defaultStyleLegendGraphic");
        Assert.assertNotNull((Object)img);
        Assert.assertEquals((long)1L, (long)img.getBehaviors().size());
        Assert.assertTrue((boolean)(img.getBehaviors().get(0) instanceof AttributeModifier));
        AttributeModifier mod = (AttributeModifier)img.getBehaviors().get(0);
        Assert.assertTrue((boolean)mod.toString().contains("wms?REQUEST=GetLegendGraphic"));
        Assert.assertTrue((boolean)mod.toString().contains("style=cite:Ponds"));
    }

    @Test
    public void testInterpolationDropDown() {
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        final Model layerModel = new Model((Serializable)layer);
        FormTestPage page = new FormTestPage(new ComponentBuilder(){

            public Component buildComponent(String id) {
                return new WMSLayerConfig(id, (IModel)layerModel);
            }
        });
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:defaultInterpolationMethod", DropDownChoice.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        tester.assertModelValue("form:panel:defaultInterpolationMethod", null);
        ft = tester.newFormTester("form");
        ft.select("panel:defaultInterpolationMethod", 2);
        ft.submit();
        tester.assertModelValue("form:panel:defaultInterpolationMethod", (Object)LayerInfo.WMSInterpolation.Bicubic);
    }
}

