/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.web.WMSAdminPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WMSAdminPageTest
extends GeoServerWicketTestSupport {
    private WMSInfo wms;

    @Before
    public void setUp() throws Exception {
        this.wms = (WMSInfo)this.getGeoServerApplication().getGeoServer().getService(WMSInfo.class);
        this.login();
    }

    @Test
    public void testValues() throws Exception {
        tester.startPage(WMSAdminPage.class);
        tester.assertModelValue("form:keywords", (Object)this.wms.getKeywords());
        tester.assertModelValue("form:srs", new ArrayList());
    }

    @Test
    public void testFormSubmit() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit("submit");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
    }

    @Test
    public void testWatermarkLocalFile() throws Exception {
        File f = new File(((Object)((Object)this)).getClass().getResource("GeoServer_75.png").toURI());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("watermark.uRL", f.getAbsolutePath());
        ft.submit("submit");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
    }

    @Test
    public void testFormInvalid() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("srs", "bla");
        ft.submit("submit");
        List errors = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertTrue((boolean)((ValidationErrorFeedback)errors.get(0)).getMessage().toString().contains("bla"));
        tester.assertRenderedPage(WMSAdminPage.class);
    }

    @Test
    public void testBBOXForEachCRS() throws Exception {
        Assert.assertFalse((boolean)this.wms.isBBOXForEachCRS());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("bBOXForEachCRS", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isBBOXForEachCRS());
    }

    @Test
    public void testRootLayerTitle() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("rootLayerTitle", "test");
        ft.setValue("rootLayerAbstract", "abstract test");
        ft.submit("submit");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)this.wms.getRootLayerTitle(), (Object)"test");
        Assert.assertEquals((Object)this.wms.getRootLayerAbstract(), (Object)"abstract test");
    }

    @Test
    public void testDynamicStylingDisabled() throws Exception {
        Assert.assertFalse((boolean)this.wms.isDynamicStylingDisabled());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("dynamicStyling.disabled", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isDynamicStylingDisabled());
    }

    @Test
    public void testCacheConfiguration() throws Exception {
        Assert.assertFalse((boolean)this.wms.getCacheConfiguration().isEnabled());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("cacheConfiguration.enabled", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.getCacheConfiguration().isEnabled());
    }

    @Test
    public void testFeaturesReprojectionDisabled() throws Exception {
        Assert.assertFalse((boolean)this.wms.isFeaturesReprojectionDisabled());
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("disableFeaturesReproject", true);
        ft.submit("submit");
        Assert.assertTrue((boolean)this.wms.isFeaturesReprojectionDisabled());
    }
}

