/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StylePage;
import org.geoserver.wms.web.data.StyleProvider;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;

public class StylePageTest
extends GeoServerWicketTestSupport {
    @Test
    public void testPageLoad() {
        this.login();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
    }

    @Test
    public void testStyleProvider() {
        this.login();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Catalog catalog = this.getCatalog();
        Assert.assertEquals((long)dv.size(), (long)catalog.getStyles().size());
        IDataProvider dataProvider = dv.getDataProvider();
        Assert.assertTrue((boolean)(dataProvider instanceof StyleProvider));
        StyleProvider provider = (StyleProvider)dataProvider;
        boolean catchedException = false;
        try {
            provider.getItems();
        }
        catch (UnsupportedOperationException e) {
            catchedException = true;
        }
        Assert.assertTrue((boolean)catchedException);
        StyleInfo actual = (StyleInfo)provider.iterator(0L, 1L).next();
        CloseableIterator list = catalog.list(StyleInfo.class, (Filter)Filter.INCLUDE, Integer.valueOf(0), Integer.valueOf(1), Predicates.sortBy((String)"name", (boolean)true));
        Assert.assertTrue((boolean)list.hasNext());
        StyleInfo expected = (StyleInfo)list.next();
        try {
            if (list != null) {
                list.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testIsDefaultStyle() {
        Catalog cat = this.getCatalog();
        Assert.assertTrue((boolean)StylePage.isDefaultStyle((CatalogInfo)cat.getStyleByName("line")));
        StyleInfo s = cat.getFactory().createStyle();
        s.setName("line");
        s.setFilename("line.sld");
        s.setWorkspace(cat.getDefaultWorkspace());
        Assert.assertFalse((boolean)StylePage.isDefaultStyle((CatalogInfo)s));
    }
}

