/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Optional;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AccessMode;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geoserver.wms.web.data.StyleNewPage;
import org.geoserver.wms.web.data.StylePage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StylePageSecurityTest
extends GeoServerWicketTestSupport {
    StyleInfo buildingsStyle;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addUser("cite", "cite", null, Arrays.asList("ROLE_CITE_ADMIN"));
        this.addLayerAccessRule("*", "*", AccessMode.READ, new String[]{"*"});
        this.addLayerAccessRule("*", "*", AccessMode.WRITE, new String[]{"*"});
        this.addLayerAccessRule("*", "*", AccessMode.ADMIN, new String[]{"ROLE_ADMINISTRATOR"});
        this.addLayerAccessRule("cite", "*", AccessMode.ADMIN, new String[]{"ROLE_CITE_ADMIN"});
    }

    @Before
    public void setUp() {
        Catalog catalog = this.getCatalog();
        this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        this.buildingsStyle.setWorkspace(catalog.getWorkspaceByName(MockData.CITE_PREFIX));
        catalog.save(this.buildingsStyle);
    }

    @After
    public void cleanUp() {
        this.logout();
    }

    void loginAsCite() {
        this.login("cite", "cite", new String[]{"ROLE_CITE_ADMIN"});
    }

    @Test
    public void testNewCite() throws URISyntaxException, IOException {
        this.loginAsCite();
        tester.startPage(StyleNewPage.class);
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("styleForm:context:panel:name", TextField.class);
        tester.assertComponent("styleForm:context:panel:format", DropDownChoice.class);
        tester.assertComponent("styleForm:context:panel:workspace", DropDownChoice.class);
        DropDownChoice format = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:format");
        TestCase.assertTrue((boolean)format.isEnabled());
        DropDownChoice workspace = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:workspace");
        TestCase.assertTrue((boolean)workspace.isEnabled());
        Assert.assertFalse((boolean)workspace.isNullValid());
        Assert.assertNotNull((Object)workspace.getModelObject());
    }

    @Test
    public void testNewCiteCiteWs() throws URISyntaxException, IOException {
        this.loginAsCite();
        tester.startPage(StyleNewPage.class);
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "cite_style");
        form.setValue("context:panel:workspace", this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX).getId());
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.executeAjaxEvent("submit", "click");
        tester.assertRenderedPage(StylePage.class);
        StyleInfo style = this.getCatalog().getStyleByName("cite_style");
        Assert.assertNotNull((Object)style);
        Assert.assertNull((Object)style.getLegend());
    }

    @Test
    public void testNewCiteSfWs() throws URISyntaxException, IOException {
        this.loginAsCite();
        tester.startPage(StyleNewPage.class);
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "sf_style");
        form.setValue("context:panel:workspace", this.getCatalog().getWorkspaceByName(MockData.SF_PREFIX).getId());
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.executeAjaxEvent("submit", "click");
        tester.assertErrorMessages(new Serializable[]{"Field 'Workspace' is required."});
        StyleInfo style = this.getCatalog().getStyleByName("sf_style");
        Assert.assertNull((Object)style);
    }

    @Test
    public void testNewAdmin() {
        this.login();
        tester.startPage(StyleNewPage.class);
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("styleForm:context:panel:name", TextField.class);
        tester.assertComponent("styleForm:context:panel:format", DropDownChoice.class);
        tester.assertComponent("styleForm:context:panel:workspace", DropDownChoice.class);
        DropDownChoice format = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:format");
        TestCase.assertTrue((boolean)format.isEnabled());
        DropDownChoice workspace = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:workspace");
        TestCase.assertTrue((boolean)workspace.isEnabled());
        TestCase.assertTrue((boolean)workspace.isNullValid());
        Assert.assertNull((Object)workspace.getModelObject());
    }

    @Test
    public void testEditCite() {
        this.loginAsCite();
        PageParameters pp = new PageParameters();
        pp.set("name", (Object)this.buildingsStyle.getName());
        pp.set("workspace", (Object)Optional.ofNullable(this.buildingsStyle.getWorkspace()).map(ws -> ws.getName()).orElse(""));
        StyleEditPage page = (StyleEditPage)tester.startPage(StyleEditPage.class, pp);
        tester.startPage((Page)page);
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("styleForm:context:panel:name", TextField.class);
        tester.assertComponent("styleForm:context:panel:format", DropDownChoice.class);
        tester.assertComponent("styleForm:context:panel:workspace", DropDownChoice.class);
        DropDownChoice format = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:format");
        Assert.assertFalse((boolean)format.isEnabled());
        DropDownChoice workspace = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:workspace");
        Assert.assertFalse((boolean)workspace.isEnabled());
        Assert.assertFalse((boolean)workspace.isNullValid());
        Assert.assertNotNull((Object)workspace.getModelObject());
    }

    @Test
    public void testEditAdmin() {
        this.login();
        StyleEditPage page = new StyleEditPage(this.buildingsStyle);
        tester.startPage((Page)page);
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("styleForm:context:panel:name", TextField.class);
        tester.assertComponent("styleForm:context:panel:format", DropDownChoice.class);
        tester.assertComponent("styleForm:context:panel:workspace", DropDownChoice.class);
        DropDownChoice format = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:format");
        Assert.assertFalse((boolean)format.isEnabled());
        DropDownChoice workspace = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:workspace");
        TestCase.assertTrue((boolean)workspace.isEnabled());
        TestCase.assertTrue((boolean)workspace.isNullValid());
        Assert.assertNotNull((Object)workspace.getModelObject());
    }
}

